/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.command.pur;

import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.core.entity.dictionary.DicGroupItem;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.dictonary.DicUtils;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.IOrderItem;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.command.pur.PricingCommand;
import com.els.base.inquiry.entity.InquiryBusiCondition;
import com.els.base.inquiry.entity.InquirySupOrder;
import com.els.base.inquiry.entity.InquirySupOrderExample;
import com.els.base.inquiry.entity.PurOrder;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.enumclass.InquiryAuditStatus;
import com.els.base.inquiry.enumclass.InquiryOrderStatus;
import com.els.base.inquiry.enumclass.InquiryQuoteStatus;
import com.els.base.inquiry.enumclass.OperationTypeEnum;
import com.els.base.materialprice.entity.MaterialPrice;
import com.els.base.utils.SpringContextHolder;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

public class PricingOrderCommand
extends AbstractInquiryCommand<String> {
    private PurOrder purOrder;

    public PricingOrderCommand(PurOrder purOrder) {
        this.purOrder = purOrder;
    }

    @Override
    public String execute(InquiryCommandInvoker invoker) {
        this.vaild(this.purOrder);
        PricingCommand pricingCommand = new PricingCommand(this.purOrder);
        pricingCommand.copyProperties(this);
        invoker.invoke(pricingCommand);
        this.logger.info("\u8bb0\u5f55\u91c7\u8d2d\u65b9\u7684\u63a5\u53d7\u6216\u62d2\u7edd\u64cd\u4f5c");
        this.purOrder.getItemList().stream().filter(item -> OperationTypeEnum.isPricingOperation(item.getOperation())).forEach(item -> {
            TemplateConf templateConf = (TemplateConf)invoker.getTemplateConfService().queryObjById(this.purOrder.getTemplateId());
            try {
                IOrderItem tmpItem = templateConf.getOrderItemClass().newInstance();
                tmpItem.setId(item.getId());
                tmpItem.setOperation(item.getOperation());
                if (InquiryQuoteStatus.REQUOTED.getCode().equals(item.getQuotationStatus())) {
                    tmpItem.setIsReQuote(Constant.YES_INT);
                }
                if (OperationTypeEnum.ACCEPTED.getCode().equals(tmpItem.getOperation())) {
                    tmpItem.setQuotationStatus(InquiryQuoteStatus.ACCEPTED.getCode());
                }
                if (OperationTypeEnum.REFUSED.getCode().equals(tmpItem.getOperation())) {
                    tmpItem.setQuotationStatus(InquiryQuoteStatus.REFUSED.getCode());
                }
                templateConf.getOrderItemService().modifyStatus(tmpItem);
                this.importPriceToMaterial((IOrderItem)item);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        });
        this.logger.info("\u5c06\u91c7\u8d2d\u65b9\u8be2\u4ef7\u5355\u5934\u72b6\u6001\u6539\u6210\u201c\u5df2\u5b9a\u4ef7\u201d\u72b6\u6001");
        PurOrder temp = new PurOrder();
        temp.setId(this.purOrder.getId());
        temp.setAuditStatus(InquiryAuditStatus.AUDIT_PASS.getCode());
        invoker.getPurOrderService().modifyObj(temp);
        this.logger.info("\u5c06\u4f9b\u5e94\u5546\u8be2\u4ef7\u5355\u5934\u72b6\u6001\u6539\u6210\u201c\u5df2\u51bb\u7ed3\u201d\u72b6\u6001");
        this.transformSupOrderToFrozen(this.purOrder);
        return null;
    }

    private void importPriceToMaterial(IOrderItem item) {
        GenerateCodeService generateCodeService = (GenerateCodeService)SpringContextHolder.getOneBean(GenerateCodeService.class);
        String code = generateCodeService.getNextCode("MATERIAL_PRICE");
        MaterialPrice materialPrice = new MaterialPrice();
        materialPrice.setMaterialPriceNo(code);
        materialPrice.setCreateTime(new Date());
        materialPrice.setMaterialPriceOrigin("3");
        materialPrice.setMaterialCode(item.getMaterialCode());
        materialPrice.setDescription(item.getMaterialDesc());
        materialPrice.setBasicUnit(item.getMeasurementUnit());
        materialPrice.setValidStartTime(item.getPriceValidTime());
        materialPrice.setValidEndTime(item.getPriceExpiredTime());
        for (InquiryBusiCondition busiCondition : this.purOrder.getBusiConditions()) {
            if (!busiCondition.getSupOrderId().equals(item.getSupOrderId())) continue;
            materialPrice.setCurrency(busiCondition.getCurrency());
            BigDecimal truePrice = item.getUntaxedUnitPrice().divide(new BigDecimal(item.getValuationUnit()), 4, 4);
            DicGroupItem dicItem = DicUtils.getDicGroupItemByCode((String)"tax_type_code", (String)busiCondition.getTaxRate());
            BigDecimal taxedUnitPrice = new BigDecimal(dicItem.getValue()).multiply(truePrice);
            materialPrice.setPrice(taxedUnitPrice);
        }
        this.invoker.getMaterialPriceService().addObj((Serializable)materialPrice);
    }

    private void vaild(PurOrder purOrder) {
        Assert.isNotNull((Object)purOrder, (String)"\u8be2\u4ef7\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull(purOrder.getItemList(), (String)"\u8be2\u4ef7\u5355\u884c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        long quotedCount = purOrder.getItemList().stream().filter(orderItem -> InquiryQuoteStatus.QUOTED.getCode().equals(orderItem.getQuotationStatus()) || InquiryQuoteStatus.REQUOTED.getCode().equals(orderItem.getQuotationStatus())).count();
        if (quotedCount <= 0L) {
            throw new CommonException("\u6ca1\u6709\u5df2\u62a5\u4ef7\u7684\u884c\u9879\u76ee\uff0c\u65e0\u6cd5\u63d0\u4ea4\u5ba1\u6279");
        }
        List<IOrderItem> orderItems = purOrder.getItemList();
        orderItems.forEach(orderItem -> {
            if ((InquiryQuoteStatus.QUOTED.getCode().equals(orderItem.getQuotationStatus()) || InquiryQuoteStatus.REQUOTED.getCode().equals(orderItem.getQuotationStatus())) && !OperationTypeEnum.ACCEPTED.getCode().equals(orderItem.getOperation())) {
                orderItem.setOperation(OperationTypeEnum.REFUSED.getCode());
            }
        });
    }

    private void transformSupOrderToFrozen(PurOrder purOrder) {
        InquirySupOrderExample example = new InquirySupOrderExample();
        example.createCriteria().andPurOrderIdEqualTo(purOrder.getId());
        InquirySupOrder tmp = new InquirySupOrder();
        tmp.setInquiryOrderStatus(InquiryOrderStatus.FROZEN.getCode());
        tmp.setAuditStatus(InquiryAuditStatus.AUDITING.getCode());
        this.invoker.getInquirySupOrderService().modifyByExample(tmp, example);
    }
}

