/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.command.pur;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.IOrderItem;
import com.els.base.inquiry.IOrderItemDetail;
import com.els.base.inquiry.ITarget;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.entity.InquiryQuoteLadder;
import com.els.base.inquiry.entity.InquirySupOrder;
import com.els.base.inquiry.entity.InquirySupOrderExample;
import com.els.base.inquiry.entity.OrderItemM001;
import com.els.base.inquiry.entity.PurOrder;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.enumclass.InquiryLadderBelongType;
import com.els.base.inquiry.enumclass.InquiryQuoteLadderType;
import com.els.base.inquiry.enumclass.InquiryQuoteStatus;
import com.els.base.inquiry.enumclass.MessageNotify;
import com.els.base.inquiry.enumclass.OperationTypeEnum;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;

public class ReQuoteCommand
extends AbstractInquiryCommand<String> {
    private String purOrderId;
    private List<IOrderItem> orderItemList;
    private TemplateConf templateConf;

    public ReQuoteCommand(String purOrderId, List<IOrderItem> orderItemList) {
        this.purOrderId = purOrderId;
        this.orderItemList = orderItemList;
    }

    @Override
    public String execute(InquiryCommandInvoker invoker) {
        Assert.isNotEmpty(this.orderItemList, (String)"\u8be2\u4ef7\u5355\u884c\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)this.purOrderId, (String)"\u8be2\u4ef7\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        PurOrder purOrder = (PurOrder)invoker.getPurOrderService().queryObjById(this.purOrderId);
        this.templateConf = (TemplateConf)invoker.getTemplateConfService().queryObjById(purOrder.getTemplateId());
        List<IOrderItem> existOrderItemList = this.orderItemList.parallelStream().map(IOrderItem::getId).distinct().map(orderItemId -> (IOrderItem)this.templateConf.getOrderItemService().queryObjById(orderItemId)).collect(Collectors.toList());
        existOrderItemList.forEach(orderItem -> this.valid((IOrderItem)orderItem));
        existOrderItemList.forEach(item -> {
            this.deletePrice((IOrderItem)item);
            this.templateConf.getOrderItemService().deleteObjById(item.getId());
        });
        List<ITarget> tempTargetList = this.templateConf.getTargetService().queryByPurOrderId(purOrder.getId());
        List<ITarget> targetList = tempTargetList.stream().filter(target -> existOrderItemList.stream().anyMatch(item -> item.getTargetId().equals(target.getId()))).collect(Collectors.toList());
        List<String> supOrderIdList = existOrderItemList.stream().map(IOrderItem::getSupOrderId).distinct().collect(Collectors.toList());
        this.addOrderItemList(purOrder, supOrderIdList, targetList, this.orderItemList);
        InquirySupOrderExample supOrderExample = new InquirySupOrderExample();
        supOrderExample.createCriteria().andIdIn((List)supOrderIdList);
        InquirySupOrder temp = new InquirySupOrder();
        temp.setQuoteStatus(InquiryQuoteStatus.REQUOTE.getCode());
        this.invoker.getInquirySupOrderService().modifyByExample(temp, supOrderExample);
        PurOrder tempPurOrder = new PurOrder();
        tempPurOrder.setId(this.purOrderId);
        tempPurOrder.setQuoteStatus(InquiryQuoteStatus.REQUOTE.getCode());
        this.invoker.getPurOrderService().modifyObj(tempPurOrder);
        supOrderIdList.parallelStream().forEach(supordrId -> {
            InquirySupOrder supOrder = (InquirySupOrder)invoker.getInquirySupOrderService().queryObjById(supordrId);
            this.sendMsg((String)supordrId, supOrder.getOrderNo(), supOrder.getSupUserId());
        });
        return null;
    }

    private void deletePrice(IOrderItem item) {
        List orderItemList = this.templateConf.getOrderItemService().queryBySupOrderId(item.getSupOrderId());
        for (IOrderItem orderItem : orderItemList) {
            if (item.getUntaxedUnitPrice() == null || BigDecimal.ZERO.compareTo(item.getUntaxedUnitPrice()) == 0 || orderItem.getTotalAmount() == null || BigDecimal.ZERO.compareTo(orderItem.getTotalAmount()) == 0) continue;
            OrderItemM001 tempOrderItem = new OrderItemM001();
            tempOrderItem.setId(orderItem.getId());
            tempOrderItem.setTotalAmount(orderItem.getTotalAmount().subtract(orderItem.getUntaxedUnitPrice()));
            this.templateConf.getOrderItemService().modifyStatus(tempOrderItem);
        }
    }

    private List<IOrderItem> addOrderItemList(PurOrder order, List<String> supOrderIdList, List<ITarget> targetList, List<IOrderItem> orderItemList) {
        Assert.isNotEmpty(targetList, (String)"\u83b7\u53d6\u4e0d\u5230\u7269\u6599\u6e05\u5355");
        List supOrderList = supOrderIdList.stream().map(supOrderId -> (InquirySupOrder)this.invoker.getInquirySupOrderService().queryObjById(supOrderId)).collect(Collectors.toList());
        List<IOrderItem> allOrderItemList = supOrderList.parallelStream().flatMap(supOrder -> targetList.stream().map(target -> {
            Class<? extends IOrderItem> orderItemCls = this.templateConf.getOrderItemClass();
            IOrderItem orderItem = null;
            try {
                orderItem = orderItemCls.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
            orderItem.build(order, (InquirySupOrder)supOrder, (ITarget)target);
            orderItem.setQuotationStatus(InquiryQuoteStatus.REQUOTE.getCode());
            orderItem.setOperation(OperationTypeEnum.NO_OPERATION.getCode());
            orderItem.setUntaxedUnitPrice(BigDecimal.ZERO);
            orderItem.setPurRemark(this.getPurRemark(orderItem, orderItemList));
            return orderItem;
        })).collect(Collectors.toList());
        int purOrderIndex = 1;
        for (IOrderItem orderItem : allOrderItemList) {
            orderItem.setOrderItemNo(purOrderIndex++);
        }
        this.templateConf.getOrderItemService().addAll(allOrderItemList);
        this.addOrderItemQuoteLadderList(allOrderItemList, targetList);
        if (Constant.YES_INT.equals(this.templateConf.getIsOrderItemDetailEnable())) {
            this.addOrderItemDetail(allOrderItemList);
        }
        return allOrderItemList;
    }

    private String getPurRemark(IOrderItem orderItem, List<IOrderItem> orderItemList) {
        return orderItemList.stream().filter(tmp -> orderItem.getSupOrderId().equals(tmp.getSupOrderId()) && orderItem.getTargetId().equals(tmp.getTargetId())).findAny().map(IOrderItem::getPurRemark).orElse(null);
    }

    private void addOrderItemQuoteLadderList(List<IOrderItem> allOrderItemList, List<ITarget> targetList) {
        Stream stream = allOrderItemList.stream().flatMap(orderItem -> targetList.stream().filter(target -> InquiryQuoteLadderType.LADDER_QUOTE.getCode().equals(target.getQuoteType())).filter(target -> {
            List<InquiryQuoteLadder> ladders = this.invoker.getInquiryQuoteLadderService().queryByTargetId(target.getId());
            if (CollectionUtils.isNotEmpty(ladders)) {
                target.setInquiryQuoteLadders(ladders);
            }
            return CollectionUtils.isNotEmpty(target.getInquiryQuoteLadders());
        }).filter(target -> target.getId().equals(orderItem.getTargetId())).flatMap(target -> target.getInquiryQuoteLadders().stream().map(ladder -> {
            InquiryQuoteLadder inquiryQuoteLadder = new InquiryQuoteLadder();
            BeanUtils.copyProperties((Object)ladder, (Object)inquiryQuoteLadder);
            inquiryQuoteLadder.setId(null);
            inquiryQuoteLadder.setBelongType(InquiryLadderBelongType.BELONG_TO_ITEM.getCode());
            inquiryQuoteLadder.setItemId(orderItem.getId());
            inquiryQuoteLadder.setCreateCompanyType("PUR");
            return inquiryQuoteLadder;
        })));
        this.invoker.getInquiryQuoteLadderService().addAll(stream.collect(Collectors.toList()));
    }

    private void addOrderItemDetail(List<IOrderItem> allOrderItemList) {
        if (CollectionUtils.isEmpty(allOrderItemList)) {
            return;
        }
        List detailList = allOrderItemList.stream().map(item -> {
            IOrderItemDetail detail = null;
            try {
                detail = this.templateConf.getTplOrderItemDetail().getOrderItemDetailClass().newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
            detail.build((IOrderItem)item);
            detail.setTemplateId(this.templateConf.getTplOrderItemDetail().getId());
            return detail;
        }).collect(Collectors.toList());
        this.templateConf.getTplOrderItemDetail().getOrderItemDetailService().addAll(detailList);
    }

    private void sendMsg(String supOrderId, String orderNo, String supUserId) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("inquirySupOrderId", supOrderId);
        data.put("orderNo", orderNo);
        Message msg = Message.init(data).setCompanyCode(this.getPurCompany().getCompanyCode()).setBusinessTypeCode(MessageNotify.INQUIRY_ORDER_REQUOTE.getCode()).setSenderId(this.getPurUser().getId()).addReceiverId(supUserId).setMsgLevel(MessageLevelEnum.HIGH);
        MessageSendUtils.sendMessage((Message)msg);
    }

    private void valid(IOrderItem orderItem) {
        if (!this.purOrderId.equals(orderItem.getPurOrderId())) {
            throw new CommonException("\u53ea\u80fd\u9009\u62e9\u4e00\u4e2a\u91cd\u62a5\u4ef7\u7684\u8be2\u4ef7\u5355\u8fdb\u884c\u91cd\u62a5\u4ef7");
        }
        if (!InquiryQuoteStatus.QUOTED.getCode().equals(orderItem.getQuotationStatus()) && !InquiryQuoteStatus.REQUOTED.getCode().equals(orderItem.getQuotationStatus())) {
            throw new CommonException("\u53ea\u6709\u5904\u4e8e\u5df2\u62a5\u4ef7\u6216\u5df2\u91cd\u62a5\u72b6\u6001\u4e0b\u7684\u884c\u624d\u80fd\u6267\u884c\u91cd\u62a5\u4ef7\u64cd\u4f5c");
        }
        OrderItemM001 tempItem = (OrderItemM001)this.templateConf.getOrderItemService().queryObjById(orderItem.getId());
        if (tempItem == null) {
            throw new CommonException("\u91cd\u62a5\u4ef7\u5df2\u6267\u884c,\u884c\u9879\u76ee\u4e0d\u5b58\u5728,\u8bf7\u5237\u65b0");
        }
    }
}

