/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.command.pur;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.IOrderItem;
import com.els.base.inquiry.ITarget;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.entity.PurOrder;
import com.els.base.inquiry.entity.TemplateConf;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class UpdateMaterialCodeCmd
extends AbstractInquiryCommand<String> {
    private String targetId;
    private String materialCode;
    private String orderId;

    public UpdateMaterialCodeCmd(String targetId, String materialCode, String orderId) {
        this.targetId = targetId;
        this.materialCode = materialCode;
        this.orderId = orderId;
    }

    @Override
    public String execute(InquiryCommandInvoker invoker) {
        Assert.isNotBlank((String)this.orderId, (String)"\u8ba2\u5355Id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)this.targetId, (String)"targetId\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)this.materialCode, (String)"\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        PurOrder order = (PurOrder)invoker.getPurOrderService().queryObjById(this.orderId);
        TemplateConf templateConf = (TemplateConf)invoker.getTemplateConfService().queryObjById(order.getTemplateId());
        List<ITarget> targetList = templateConf.getTargetService().queryByPurOrderId(this.orderId);
        ITarget target = targetList.stream().filter(tmp -> tmp.getId().equals(this.targetId)).findAny().orElse(null);
        if (target == null) {
            throw new CommonException("\u627e\u4e0d\u5230\u8be5\u7269\u6599");
        }
        target.setMaterialCode(this.materialCode);
        templateConf.getTargetService().modifyStatus(target);
        List<IOrderItem> itemList = templateConf.getOrderItemService().queryByPurOrderId(this.orderId);
        itemList = itemList.stream().filter(item -> item.getTargetId().equals(this.targetId)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(itemList)) {
            for (IOrderItem iOrderItem : itemList) {
                iOrderItem.setMaterialCode(this.materialCode);
                templateConf.getOrderItemService().modifyStatus(iOrderItem);
            }
        }
        return null;
    }
}

