/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.command.sup;

import com.els.base.core.entity.IExample;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.IOrderItemDetailService;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.entity.InquiryBusiCondition;
import com.els.base.inquiry.entity.InquiryBusiConditionExample;
import com.els.base.inquiry.entity.InquirySupFile;
import com.els.base.inquiry.entity.InquirySupFileExample;
import com.els.base.inquiry.entity.InquirySupOrder;
import com.els.base.inquiry.entity.TemplateConf;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class SupViewDetailCommand
extends AbstractInquiryCommand<InquirySupOrder> {
    private String supOrderId;

    public SupViewDetailCommand(String supOrderId) {
        Assert.isNotBlank((String)supOrderId, (String)"\u4f9b\u5e94\u5546\u8be2\u4ef7\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        this.supOrderId = supOrderId;
    }

    @Override
    public InquirySupOrder execute(InquiryCommandInvoker invoker) {
        InquirySupOrder supOrder = (InquirySupOrder)invoker.getInquirySupOrderService().queryObjById(this.supOrderId);
        TemplateConf templateConf = (TemplateConf)invoker.getTemplateConfService().queryObjById(supOrder.getTemplateId());
        supOrder.setTemplateConf(templateConf);
        if (StringUtils.isNotBlank((String)supOrder.getPurOrderId())) {
            supOrder.setPurFileList(invoker.getInquiryPurFileService().queryByPurOrderId(supOrder.getPurOrderId()));
        }
        supOrder.setSupFileList(this.querySupFilesBySupOrderId(supOrder.getId()));
        supOrder.setBusiConditions(this.queryBusiConditionsBySupOrderId(supOrder.getId()));
        supOrder.setItemList(templateConf.getOrderItemService().queryBySupOrderId(this.supOrderId));
        supOrder.getItemList().parallelStream().forEach(item -> {
            item.setInquiryQuoteLadders(invoker.getInquiryQuoteLadderService().queryByOrderItemId(item.getId()));
            if (Constant.YES_INT.equals(templateConf.getIsOrderItemDetailEnable())) {
                IOrderItemDetailService service = templateConf.getTplOrderItemDetail().getOrderItemDetailService();
                item.setOrderItemDetail(service.queryObjByOrderItemId(item.getId()));
            }
        });
        return supOrder;
    }

    private List<InquiryBusiCondition> queryBusiConditionsBySupOrderId(String orderId) {
        InquiryBusiConditionExample example = new InquiryBusiConditionExample();
        example.createCriteria().andSupOrderIdEqualTo(orderId);
        List inquiryBusiConditions = this.invoker.getInquiryBusiConditionService().queryAllObjByExample((IExample)example);
        if (inquiryBusiConditions == null || inquiryBusiConditions.size() != 1) {
            inquiryBusiConditions = null;
        }
        return inquiryBusiConditions;
    }

    private List<InquirySupFile> querySupFilesBySupOrderId(String orderId) {
        InquirySupFileExample example = new InquirySupFileExample();
        example.createCriteria().andSupOrderIdEqualTo(orderId);
        return this.invoker.getInquirySupFileService().queryAllObjByExample((IExample)example);
    }
}

