/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.entity;

import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.inquiry.AbstractOrderItem;
import com.els.base.inquiry.IOrderItem;
import com.els.base.inquiry.IOrderItemService;
import com.els.base.inquiry.ITarget;
import com.els.base.inquiry.entity.InquirySupOrder;
import com.els.base.inquiry.entity.MaterielParity;
import com.els.base.inquiry.entity.PropertyDef;
import com.els.base.inquiry.entity.PropertyValue;
import com.els.base.inquiry.entity.PurOrder;
import com.els.base.inquiry.entity.SystemPrice;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.enumclass.InquiryQuoteStatus;
import com.els.base.inquiry.service.OrderItemM001Service;
import com.els.base.inquiry.service.PurOrderService;
import com.els.base.inquiry.service.SystemPriceService;
import com.els.base.inquiry.service.TemplateConfService;
import com.els.base.inquiry.utils.PropertyDefUtils;
import com.els.base.inquiry.utils.json.ExtendableObjectJsonSerialzer;
import com.els.base.inquiry.utils.json.OrderItemJsonDeSerialzer;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.uuid.UUIDGenerator;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;

@JsonSerialize(using=ExtendableObjectJsonSerialzer.class)
@JsonDeserialize(using=OrderItemJsonDeSerialzer.class)
@ApiModel(value="\u8be2\u62a5\u4ef7-\u884c\u6570\u636e-M001")
public class OrderItemM001
extends AbstractOrderItem {
    public static final Integer UN_IMPORT_SAP = 2;
    private List<PropertyValue> propertyValueList;
    @ApiModelProperty(hidden=true, value="\u53c2\u7167\u7269\u6599\u5bf9\u6bd4", dataType="button")
    private List<MaterielParity> materielParitys;
    @ApiModelProperty(value="\u5ba1\u6279\u72b6\u6001\uff0c1\u672a\u5ba1\u6279\uff0c2\u5ba1\u6279\u4e2d\uff0c3\u5ba1\u6279\u901a\u8fc7\uff0c4\u5ba1\u6279\u9a73\u56de")
    private Integer auditStatus;
    @ApiModelProperty(hidden=true, name="\u4e3b\u952e")
    private String id;
    @ApiModelProperty(hidden=true, name="\u91c7\u8d2d\u65b9\u8868\u5934id")
    private String purOrderId;
    @ApiModelProperty(hidden=true, name="\u4f9b\u5e94\u65b9\u8868\u5934id")
    private String supOrderId;
    @ApiModelProperty(hidden=true, name="\u8be2\u4ef7\u5355\u53f7")
    private String orderNo;
    @ApiModelProperty(hidden=true, name="\u8be2\u4ef7\u5355\u884c\u53f7(\u91c7\u8d2d\u65b9)")
    private Integer orderItemNo;
    @ApiModelProperty(position=1, value="\u7269\u6599\u7f16\u7801")
    private String materialCode;
    @ApiModelProperty(position=2, value="\u7269\u6599\u63cf\u8ff0", required=true)
    private String materialDesc;
    @ApiModelProperty(position=4, value="\u54c1\u724c")
    private String brand;
    @ApiModelProperty(position=5, value="\u53c2\u7167\u54c1\u53f7")
    private String comparisonMaterialName;
    @ApiModelProperty(hidden=true, name="\u6392\u5e8f\u53f7(\u4f9b\u5e94\u5546\u884c\u53f7)")
    private Integer sortNo;
    @ApiModelProperty(position=11, value="\u539f\u5382\u578b\u53f7/\u540d\u79f0", required=true)
    private String originalModelOrName;
    @ApiModelProperty(position=14, value="MOQ")
    private Integer moq;
    @ApiModelProperty(position=13, value="\u4f9b\u5e94\u4fdd\u969c\u622a\u6b62\u65f6\u95f4")
    private Date supGuaranteeEndTime;
    @ApiModelProperty(position=12, value="\u5668\u4ef6\u7b49\u7ea7", dataType="dic_group", notes="device_level")
    private String deviceLevel;
    @ApiModelProperty(hidden=true, position=19, value="\u5e01\u522b", dataType="dic_group", notes="zr_ordercurren")
    private String currency;
    @ApiModelProperty(position=20, value="\u4e0d\u542b\u7a0e\u4ef7", required=true)
    private BigDecimal untaxedUnitPrice;
    @ApiModelProperty(position=17, value="\u8ba1\u91cf\u5355\u4f4d", dataType="dic_group", notes="measurementUnit", required=true)
    private String measurementUnit;
    @ApiModelProperty(hidden=true, value="\u64cd\u4f5c(\u63a5\u53d7/\u62d2\u7edd)", dataType="button")
    private Integer operation;
    @ApiModelProperty(hidden=true, name="\u62a5\u4ef7\u72b6\u6001")
    private Integer quotationStatus;
    @ApiModelProperty(hidden=true, value="\u5b9a\u4ef7\u8bf4\u660e")
    private String pricingDescription;
    @ApiModelProperty(position=-2, value="\u4f9b\u5e94\u5546\u7f16\u7801")
    private String supCompanySrmCode;
    @ApiModelProperty(position=-2, value="\u4f9b\u5e94\u5546\u540d\u79f0")
    private String supCompanyName;
    @ApiModelProperty(position=28, value="\u7533\u8bf7\u65e5\u671f")
    private Date offerTime;
    @ApiModelProperty(position=-1, value="\u62a5\u4ef7\u4eba")
    private String supUserName;
    @ApiModelProperty(value="\u65e0\u6cd5\u62a5\u4ef7", dataType="button")
    private Integer unableToQuote;
    @ApiModelProperty(value="ERP\u7cfb\u7edf\u4ef7")
    private BigDecimal erpSystemPrice;
    @ApiModelProperty(value="ERP\u7cfb\u7edf\u4ef7\u5bf9\u6bd4")
    private BigDecimal erpSystemPriceComparison;
    @ApiModelProperty(value="\u76ee\u6807\u4ef7\u5bf9\u6bd4")
    private BigDecimal targetPriceComparison;
    @ApiModelProperty(value="\u53c2\u7167\u7269\u6599\u5bf9\u6bd4")
    private String referenceMaterialComparison;
    @ApiModelProperty(hidden=true, value="\u5386\u53f2\u4ef7\u683c", dataType="button")
    private String historicalPrice;
    @ApiModelProperty(hidden=true, value="\u521b\u5efa\u65f6\u95f4")
    private Date createTime;
    @ApiModelProperty(hidden=true, value="\u66f4\u65b0\u65f6\u95f4")
    private Date updateTime;
    @ApiModelProperty(hidden=true, name="\u8bb0\u5f55\u662f\u5426\u53ef\u7528(0=\u4e0d\u53ef\u7528\uff0c1=\u53ef\u7528)")
    private Integer isEnable;
    @ApiModelProperty(position=18, value="\u8ba1\u4ef7\u5355\u4f4d", required=true, dataType="dic_group", notes="valuationUnit")
    private Integer valuationUnit;
    @ApiModelProperty(hidden=true, value="\u6a21\u677fID")
    private String templateId;
    @ApiModelProperty(hidden=true, value="\u5f85\u8be2\u4ef7\u7269\u6599ID")
    private String waitMaterialId;
    @ApiModelProperty(value="\u62a5\u4ef7\u65b9\u5f0f", dataType="button", position=15)
    private Integer quoteType;
    @ApiModelProperty(hidden=true, value="\u62a5\u4ef7\u4ebaid")
    private String supUserId;
    @ApiModelProperty(position=3, value="\u54c1\u540d")
    private String materialName;
    @ApiModelProperty(position=5, value="\u4f7f\u7528\u6750\u6599")
    private String usedMaterial;
    @ApiModelProperty(position=6, value="\u51c0\u91cd\u5355\u4f4d", dataType="dic_group", notes="unit")
    private String unit;
    @ApiModelProperty(position=7, value="\u5355\u53f0\u7528\u91cf")
    private Integer amountUsed;
    @ApiModelProperty(position=8, value="\u989c\u8272")
    private String color;
    @ApiModelProperty(position=9, value="\u52a0\u5de5\u5185\u5bb9")
    private String processContent;
    @ApiModelProperty(hidden=true, position=21, value="\u7a0e\u7801", dataType="dic_group", notes="tax_type_code")
    private String saleTaxCode;
    @ApiModelProperty(position=22, value="\u4ef7\u683c\u6709\u6548\u8d77\u59cb\u65e5\u671f", required=true)
    private Date priceValidTime;
    @ApiModelProperty(position=23, value="\u4ef7\u683c\u6709\u6548\u622a\u6b62\u65f6\u95f4", required=true)
    private Date priceExpiredTime;
    @ApiModelProperty(position=26, value="\u673a\u79cd\u540d")
    private String machineModel;
    @ApiModelProperty(position=27, value="\u6280\u672f\u62c5\u5f53")
    private String technology;
    @ApiModelProperty(position=29, value="\u5b8c\u6210\u65f6\u95f4")
    private Date finishTime;
    @ApiModelProperty(hidden=true, name="\u7269\u6599\u6e05\u5355id")
    private String targetId;
    @ApiModelProperty(hidden=true, name="\u4f9b\u5e94\u5546id")
    private String supCompanyId;
    @ApiModelProperty(position=-2, value="\u4f9b\u5e94\u5546SAP\u7f16\u7801")
    private String supCompanySapCode;
    @ApiModelProperty(hidden=true)
    private Integer isOrderItemDetailEnable;
    @ApiModelProperty(value="\u76ee\u6807\u4ef7\u683c")
    private BigDecimal targetPrice;
    @ApiModelProperty(position=25, value="\u6a21\u5177\u7f16\u7801")
    private String mouldCode;
    @ApiModelProperty(position=30, value="\u539f\u4ea7\u5730", required=true)
    private String supMaterialGroup;
    @ApiModelProperty(position=30, value="\u4f9b\u5e94\u5546\u7269\u6599\u53f7")
    private String supMaterialCode;
    @ApiModelProperty(position=-1, value="\u62a5\u4ef7\u65f6\u95f4")
    private Date quoteTime;
    @ApiModelProperty(position=31, value="\u5907\u6ce8")
    private String remark;
    @ApiModelProperty(value="\u51fa\u6a21\u6570")
    private BigDecimal outOfModulus;
    @ApiModelProperty(hidden=true, name="\u5408\u8ba1\u91d1\u989d")
    private BigDecimal totalAmount;
    @ApiModelProperty(hidden=true, name="\u662f\u5426\u91cd\u62a5\u4ef7")
    private Integer isReQuote;
    @ApiModelProperty(hidden=true, name="\u662f\u5426\u5bfc\u5165sap")
    private Integer isImportSap;
    @ApiModelProperty(hidden=true, name="\u8be2\u4ef7\u5355\u4f9b\u5e94\u5546id")
    private String supTempCompanyId;
    @ApiModelProperty(name="MPQ")
    private Integer mpq;
    @ApiModelProperty(name="leadTime")
    private Integer leadTime;
    @ApiModelProperty(name="\u91cf\u4ea7\u65f6\u95f4")
    private Date volumeTime;
    @ApiModelProperty(name="\u51c0\u91cd")
    private BigDecimal netWeight;
    @ApiModelProperty(name="\u6c47\u7387")
    private BigDecimal exchangeRate;
    @ApiModelProperty(name="\u62d2\u7edd\u539f\u56e0", hidden=true)
    private String purRemark;
    @ApiModelProperty(hidden=true, name="SAP\u5199\u5165\u5931\u8d25\u539f\u56e0", access="PUR_TYPE")
    private String failReason;
    @ApiModelProperty(value="\u91c7\u8d2d\u5458ID")
    private String purUserId;
    @ApiModelProperty(value="\u91c7\u8d2d\u5458\u540d\u79f0")
    private String purUserName;
    @ApiModelProperty(name="\u5b58\u50a8\u6709\u6548\u671f(\u6708)", required=true)
    private Integer saveExpired;
    private static final long serialVersionUID = 1L;

    @Override
    public void isVaildForQuote() {
        Assert.isNotNull((Object)this.getUntaxedUnitPrice(), (String)"\u4e0d\u542b\u7a0e\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)this.getOriginalModelOrName(), (String)"\u539f\u5382\u578b\u53f7/\u63cf\u8ff0\u201d\u4e3a\u5fc5\u586b\u5b57\u6bb5\uff0c\u5982\u679c\u6ca1\u6709\uff0c\u8bf7\u586b\u65e0\uff01");
        Assert.isNotBlank((String)this.getMeasurementUnit(), (String)"\u8ba1\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)this.getValuationUnit(), (String)"\u8ba1\u4ef7\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)this.getMaterialDesc(), (String)"\u7269\u6599\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)this.getPriceValidTime(), (String)"\u4ef7\u683c\u6709\u6548\u8d77\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)this.getPriceExpiredTime(), (String)"\u4ef7\u683c\u6709\u6548\u622a\u6b62\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        if (Constant.NO_INT.equals(this.getUnableToQuote())) {
            Assert.isNotBlank((String)this.getSupMaterialGroup(), (String)"\u539f\u4ea7\u5730\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
        }
    }

    @Override
    public IOrderItem build(PurOrder order, InquirySupOrder supOrder, ITarget target) {
        BeanUtils.copyProperties((Object)target, (Object)this);
        this.setId(UUIDGenerator.generateUUID());
        this.setTemplateId(target.getTemplateId());
        if (order != null) {
            this.setOrderNo(order.getOrderNo());
            this.setPurUserId(order.getPurUserId());
            this.setPurUserName(order.getPurUserName());
        }
        if (supOrder != null) {
            this.setPurOrderId(supOrder.getPurOrderId());
            this.setSupOrderId(supOrder.getId());
            this.setSupCompanyId(supOrder.getSupCompanyId());
            this.setSupCompanyName(supOrder.getSupCompanyName());
            if (StringUtils.isNotBlank((String)supOrder.getSupCompanySapCode())) {
                this.setSupCompanySapCode(supOrder.getSupCompanySapCode());
            }
            this.setSupCompanySrmCode(supOrder.getSupCompanySrmCode());
            this.setSupTempCompanyId(supOrder.getSupTempCompanyId());
        }
        this.setOrderItemNo(target.getOrderItemNo());
        this.setTargetId(target.getId());
        this.setMaterialCode(target.getMaterialCode());
        this.setMaterialDesc(target.getMaterialDesc());
        this.setBrand(target.getBrand());
        this.setComparisonMaterialName(target.getComparisonMaterialName());
        this.setQuoteType(target.getQuoteType());
        this.setSortNo(target.getSortNo());
        this.setWaitMaterialId(target.getWaitMaterialId());
        this.setIsImportSap(UN_IMPORT_SAP);
        this.setCreateTime(new Date());
        this.setUnableToQuote(Constant.NO_INT);
        this.setQuotationStatus(InquiryQuoteStatus.UNQUOTED.getCode());
        if (StringUtils.isNotBlank((String)target.getMaterialCode()) && supOrder != null && StringUtils.isNotBlank((String)supOrder.getSupCompanySapCode()) && this.createTime != null) {
            this.setErpSystemPrice(this.querySystemPriceByMaterialCode(target.getMaterialCode(), supOrder.getSupCompanySapCode(), this.createTime));
        }
        if (CollectionUtils.isEmpty(target.getPropertyValueList())) {
            return this;
        }
        List<PropertyValue> propertyValueList = target.getPropertyValueList().stream().map(propertyValue -> {
            PropertyValue temp = new PropertyValue();
            BeanUtils.copyProperties((Object)propertyValue, (Object)temp);
            temp.setId(null);
            return temp;
        }).collect(Collectors.toList());
        this.setPropertyValueList(propertyValueList);
        return this;
    }

    private BigDecimal querySystemPriceByMaterialCode(String materialCode, String supCompanySapCode, Date createTime) {
        SystemPriceService systemPriceService = (SystemPriceService)SpringContextHolder.getOneBean(SystemPriceService.class);
        SystemPrice systemPrice = systemPriceService.queryByMaterialAndSupCompany(materialCode, supCompanySapCode, createTime);
        if (systemPrice == null) {
            return null;
        }
        BigDecimal untaxedUnitPrice = systemPrice.getUntaxedUnitPrice();
        if (systemPrice.getPriceUnit() != null) {
            untaxedUnitPrice = untaxedUnitPrice.divide(new BigDecimal(systemPrice.getPriceUnit()), 2, 4);
        }
        return untaxedUnitPrice;
    }

    @Override
    public List<PropertyValue> getPropertyValueList() {
        return this.propertyValueList;
    }

    @Override
    public void setPropertyValueList(List<PropertyValue> propertyValueList) {
        this.propertyValueList = propertyValueList;
    }

    @Override
    public List<PropertyDef> getPropertyDefList() {
        PurOrder purOrder;
        if (StringUtils.isNotBlank((String)this.getTemplateId())) {
            TemplateConf templateConf = (TemplateConf)((TemplateConfService)SpringContextHolder.getOneBean(TemplateConfService.class)).queryObjById(this.getTemplateId());
            return templateConf.getOrderItemPropertyDefList();
        }
        if (StringUtils.isNotBlank((String)this.getPurOrderId()) && (purOrder = (PurOrder)((PurOrderService)SpringContextHolder.getOneBean(PurOrderService.class)).queryObjById(this.getPurOrderId())) != null && StringUtils.isNotBlank((String)purOrder.getTemplateId())) {
            TemplateConf templateConf = (TemplateConf)((TemplateConfService)SpringContextHolder.getOneBean(TemplateConfService.class)).queryObjById(purOrder.getTemplateId());
            return templateConf.getOrderItemPropertyDefList();
        }
        return PropertyDefUtils.getProperyDefByClass(this.getClass());
    }

    public List<MaterielParity> getMaterielParitys() {
        return this.materielParitys;
    }

    @Override
    public void setMaterielParitys(List<MaterielParity> materielParitys) {
        this.materielParitys = materielParitys;
    }

    @Override
    public Class<? extends IOrderItemService> getOrderItemService() {
        return OrderItemM001Service.class;
    }

    public Integer getAuditStatus() {
        return this.auditStatus;
    }

    public void setAuditStatus(Integer auditStatus) {
        this.auditStatus = auditStatus;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    @Override
    public String getPurOrderId() {
        return this.purOrderId;
    }

    @Override
    public void setPurOrderId(String purOrderId) {
        this.purOrderId = purOrderId == null ? null : purOrderId.trim();
    }

    @Override
    public String getSupOrderId() {
        return this.supOrderId;
    }

    @Override
    public void setSupOrderId(String supOrderId) {
        this.supOrderId = supOrderId == null ? null : supOrderId.trim();
    }

    public String getOrderNo() {
        return this.orderNo;
    }

    @Override
    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo == null ? null : orderNo.trim();
    }

    public Integer getOrderItemNo() {
        return this.orderItemNo;
    }

    @Override
    public void setOrderItemNo(Integer orderItemNo) {
        this.orderItemNo = orderItemNo;
    }

    @Override
    public String getMaterialCode() {
        return this.materialCode;
    }

    @Override
    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode == null ? null : materialCode.trim();
    }

    @Override
    public String getMaterialDesc() {
        return this.materialDesc;
    }

    public void setMaterialDesc(String materialDesc) {
        this.materialDesc = materialDesc == null ? null : materialDesc.trim();
    }

    public String getBrand() {
        return this.brand;
    }

    public void setBrand(String brand) {
        this.brand = brand == null ? null : brand.trim();
    }

    public String getComparisonMaterialName() {
        return this.comparisonMaterialName;
    }

    public void setComparisonMaterialName(String comparisonMaterialName) {
        this.comparisonMaterialName = comparisonMaterialName == null ? null : comparisonMaterialName.trim();
    }

    public Integer getSortNo() {
        return this.sortNo;
    }

    public void setSortNo(Integer sortNo) {
        this.sortNo = sortNo;
    }

    public String getOriginalModelOrName() {
        return this.originalModelOrName;
    }

    public void setOriginalModelOrName(String originalModelOrName) {
        this.originalModelOrName = originalModelOrName == null ? null : originalModelOrName.trim();
    }

    public Integer getMoq() {
        return this.moq;
    }

    public void setMoq(Integer moq) {
        this.moq = moq;
    }

    public Date getSupGuaranteeEndTime() {
        return this.supGuaranteeEndTime;
    }

    public void setSupGuaranteeEndTime(Date supGuaranteeEndTime) {
        this.supGuaranteeEndTime = supGuaranteeEndTime;
    }

    public String getDeviceLevel() {
        return this.deviceLevel;
    }

    public void setDeviceLevel(String deviceLevel) {
        this.deviceLevel = deviceLevel == null ? null : deviceLevel.trim();
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency == null ? null : currency.trim();
    }

    @Override
    public BigDecimal getUntaxedUnitPrice() {
        return this.untaxedUnitPrice;
    }

    @Override
    public void setUntaxedUnitPrice(BigDecimal untaxedUnitPrice) {
        this.untaxedUnitPrice = untaxedUnitPrice;
    }

    @Override
    public String getMeasurementUnit() {
        return this.measurementUnit;
    }

    public void setMeasurementUnit(String measurementUnit) {
        this.measurementUnit = measurementUnit == null ? null : measurementUnit.trim();
    }

    @Override
    public Integer getOperation() {
        return this.operation;
    }

    @Override
    public void setOperation(Integer operation) {
        this.operation = operation;
    }

    @Override
    public Integer getQuotationStatus() {
        return this.quotationStatus;
    }

    @Override
    public void setQuotationStatus(Integer quotationStatus) {
        this.quotationStatus = quotationStatus;
    }

    public String getPricingDescription() {
        return this.pricingDescription;
    }

    public void setPricingDescription(String pricingDescription) {
        this.pricingDescription = pricingDescription == null ? null : pricingDescription.trim();
    }

    @Override
    public String getSupCompanySrmCode() {
        return this.supCompanySrmCode;
    }

    @Override
    public void setSupCompanySrmCode(String supCompanySrmCode) {
        this.supCompanySrmCode = supCompanySrmCode == null ? null : supCompanySrmCode.trim();
    }

    @Override
    public String getSupCompanyName() {
        return this.supCompanyName;
    }

    @Override
    public void setSupCompanyName(String supCompanyName) {
        this.supCompanyName = supCompanyName == null ? null : supCompanyName.trim();
    }

    public Date getOfferTime() {
        return this.offerTime;
    }

    public void setOfferTime(Date offerTime) {
        this.offerTime = offerTime;
    }

    @Override
    public String getSupUserName() {
        return this.supUserName;
    }

    @Override
    public void setSupUserName(String supUserName) {
        this.supUserName = supUserName == null ? null : supUserName.trim();
    }

    @Override
    public Integer getUnableToQuote() {
        return this.unableToQuote;
    }

    public void setUnableToQuote(Integer unableToQuote) {
        this.unableToQuote = unableToQuote;
    }

    @Override
    public BigDecimal getErpSystemPrice() {
        return this.erpSystemPrice;
    }

    @Override
    public void setErpSystemPrice(BigDecimal erpSystemPrice) {
        this.erpSystemPrice = erpSystemPrice;
    }

    @Override
    public BigDecimal getErpSystemPriceComparison() {
        return this.erpSystemPriceComparison;
    }

    @Override
    public void setErpSystemPriceComparison(BigDecimal erpSystemPriceComparison) {
        this.erpSystemPriceComparison = erpSystemPriceComparison;
    }

    @Override
    public BigDecimal getTargetPriceComparison() {
        return this.targetPriceComparison;
    }

    @Override
    public void setTargetPriceComparison(BigDecimal targetPriceComparison) {
        this.targetPriceComparison = targetPriceComparison;
    }

    public String getReferenceMaterialComparison() {
        return this.referenceMaterialComparison;
    }

    public void setReferenceMaterialComparison(String referenceMaterialComparison) {
        this.referenceMaterialComparison = referenceMaterialComparison;
    }

    public String getHistoricalPrice() {
        return this.historicalPrice;
    }

    public void setHistoricalPrice(String historicalPrice) {
        this.historicalPrice = historicalPrice == null ? null : historicalPrice.trim();
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Integer getIsEnable() {
        return this.isEnable;
    }

    public void setIsEnable(Integer isEnable) {
        this.isEnable = isEnable;
    }

    @Override
    public String getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId == null ? null : templateId.trim();
    }

    public String getWaitMaterialId() {
        return this.waitMaterialId;
    }

    public void setWaitMaterialId(String waitMaterialId) {
        this.waitMaterialId = waitMaterialId == null ? null : waitMaterialId.trim();
    }

    @Override
    public Integer getQuoteType() {
        return this.quoteType;
    }

    @Override
    public void setQuoteType(Integer quoteType) {
        this.quoteType = quoteType;
    }

    @Override
    public String getSupUserId() {
        return this.supUserId;
    }

    @Override
    public void setSupUserId(String supUserId) {
        this.supUserId = supUserId == null ? null : supUserId.trim();
    }

    public String getMaterialName() {
        return this.materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName == null ? null : materialName.trim();
    }

    public String getUsedMaterial() {
        return this.usedMaterial;
    }

    public void setUsedMaterial(String usedMaterial) {
        this.usedMaterial = usedMaterial == null ? null : usedMaterial.trim();
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit == null ? null : unit.trim();
    }

    public Integer getAmountUsed() {
        return this.amountUsed;
    }

    public void setAmountUsed(Integer amountUsed) {
        this.amountUsed = amountUsed;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color == null ? null : color.trim();
    }

    public String getProcessContent() {
        return this.processContent;
    }

    public void setProcessContent(String processContent) {
        this.processContent = processContent == null ? null : processContent.trim();
    }

    @Override
    public String getSaleTaxCode() {
        return this.saleTaxCode;
    }

    @Override
    public void setSaleTaxCode(String saleTaxCode) {
        this.saleTaxCode = saleTaxCode == null ? null : saleTaxCode.trim();
    }

    @Override
    public Date getPriceValidTime() {
        return this.priceValidTime;
    }

    @Override
    public void setPriceValidTime(Date priceValidTime) {
        this.priceValidTime = priceValidTime;
    }

    @Override
    public Date getPriceExpiredTime() {
        return this.priceExpiredTime;
    }

    @Override
    public void setPriceExpiredTime(Date priceExpiredTime) {
        this.priceExpiredTime = priceExpiredTime;
    }

    public String getMachineModel() {
        return this.machineModel;
    }

    public void setMachineModel(String machineModel) {
        this.machineModel = machineModel == null ? null : machineModel.trim();
    }

    public String getTechnology() {
        return this.technology;
    }

    public void setTechnology(String technology) {
        this.technology = technology == null ? null : technology.trim();
    }

    public Date getFinishTime() {
        return this.finishTime;
    }

    public void setFinishTime(Date finishTime) {
        this.finishTime = finishTime;
    }

    @Override
    public String getTargetId() {
        return this.targetId;
    }

    @Override
    public void setTargetId(String targetId) {
        this.targetId = targetId == null ? null : targetId.trim();
    }

    @Override
    public String getSupCompanyId() {
        return this.supCompanyId;
    }

    public void setSupCompanyId(String supCompanyId) {
        this.supCompanyId = supCompanyId == null ? null : supCompanyId.trim();
    }

    @Override
    public String getSupCompanySapCode() {
        return this.supCompanySapCode;
    }

    @Override
    public void setSupCompanySapCode(String supCompanySapCode) {
        this.supCompanySapCode = supCompanySapCode == null ? null : supCompanySapCode.trim();
    }

    @Override
    public Integer getIsOrderItemDetailEnable() {
        return this.isOrderItemDetailEnable;
    }

    public void setIsOrderItemDetailEnable(Integer isOrderItemDetailEnable) {
        this.isOrderItemDetailEnable = isOrderItemDetailEnable;
    }

    @Override
    public BigDecimal getTargetPrice() {
        return this.targetPrice;
    }

    @Override
    public void setTargetPrice(BigDecimal targetPrice) {
        this.targetPrice = targetPrice;
    }

    public String getMouldCode() {
        return this.mouldCode;
    }

    public void setMouldCode(String mouldCode) {
        this.mouldCode = mouldCode == null ? null : mouldCode.trim();
    }

    public String getSupMaterialGroup() {
        return this.supMaterialGroup;
    }

    public void setSupMaterialGroup(String supMaterialGroup) {
        this.supMaterialGroup = supMaterialGroup == null ? null : supMaterialGroup.trim();
    }

    public String getSupMaterialCode() {
        return this.supMaterialCode;
    }

    public void setSupMaterialCode(String supMaterialCode) {
        this.supMaterialCode = supMaterialCode == null ? null : supMaterialCode.trim();
    }

    @Override
    public Date getQuoteTime() {
        return this.quoteTime;
    }

    @Override
    public void setQuoteTime(Date quoteTime) {
        this.quoteTime = quoteTime;
    }

    @Override
    public Integer getValuationUnit() {
        return this.valuationUnit;
    }

    public void setValuationUnit(Integer valuationUnit) {
        this.valuationUnit = valuationUnit;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark == null ? null : remark.trim();
    }

    public BigDecimal getOutOfModulus() {
        return this.outOfModulus;
    }

    public void setOutOfModulus(BigDecimal outOfModulus) {
        this.outOfModulus = outOfModulus;
    }

    @Override
    public BigDecimal getTotalAmount() {
        return this.totalAmount;
    }

    @Override
    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    @Override
    public Integer getIsReQuote() {
        return this.isReQuote;
    }

    @Override
    public void setIsReQuote(Integer isReQuote) {
        this.isReQuote = isReQuote;
    }

    @Override
    public Integer getIsImportSap() {
        return this.isImportSap;
    }

    @Override
    public void setIsImportSap(Integer isImportSap) {
        this.isImportSap = isImportSap;
    }

    @Override
    public String getSupTempCompanyId() {
        return this.supTempCompanyId;
    }

    @Override
    public void setSupTempCompanyId(String supTempCompanyId) {
        this.supTempCompanyId = supTempCompanyId == null ? null : supTempCompanyId.trim();
    }

    public Integer getMpq() {
        return this.mpq;
    }

    public void setMpq(Integer mpq) {
        this.mpq = mpq;
    }

    public Integer getLeadTime() {
        return this.leadTime;
    }

    public void setLeadTime(Integer leadTime) {
        this.leadTime = leadTime;
    }

    public Date getVolumeTime() {
        return this.volumeTime;
    }

    public void setVolumeTime(Date volumeTime) {
        this.volumeTime = volumeTime;
    }

    public BigDecimal getNetWeight() {
        return this.netWeight;
    }

    public void setNetWeight(BigDecimal netWeight) {
        this.netWeight = netWeight;
    }

    public BigDecimal getExchangeRate() {
        return this.exchangeRate;
    }

    public void setExchangeRate(BigDecimal exchangeRate) {
        this.exchangeRate = exchangeRate;
    }

    @Override
    public String getPurRemark() {
        return this.purRemark;
    }

    @Override
    public void setPurRemark(String purRemark) {
        this.purRemark = purRemark == null ? null : purRemark.trim();
    }

    @Override
    public String getFailReason() {
        return this.failReason;
    }

    @Override
    public void setFailReason(String failReason) {
        this.failReason = failReason == null ? null : failReason.trim();
    }

    public String getPurUserId() {
        return this.purUserId;
    }

    public void setPurUserId(String purUserId) {
        this.purUserId = purUserId;
    }

    public String getPurUserName() {
        return this.purUserName;
    }

    public void setPurUserName(String purUserName) {
        this.purUserName = purUserName;
    }

    public Integer getSaveExpired() {
        return this.saveExpired;
    }

    public void setSaveExpired(Integer saveExpired) {
        this.saveExpired = saveExpired;
    }
}

