/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.inquiry.dao.TplOrderItemDetailMapper;
import com.els.base.inquiry.entity.PropertyDef;
import com.els.base.inquiry.entity.TplOrderItemDetail;
import com.els.base.inquiry.entity.TplOrderItemDetailExample;
import com.els.base.inquiry.enumclass.PropertyDefTplType;
import com.els.base.inquiry.service.PropertyDefService;
import com.els.base.inquiry.service.TplOrderItemDetailService;
import com.els.base.inquiry.utils.PropertyDefUtils;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultTplOrderItemDetailService")
public class TplOrderItemDetailServiceImpl
implements TplOrderItemDetailService {
    @Resource
    protected TplOrderItemDetailMapper tplOrderItemDetailMapper;
    @Resource
    protected PropertyDefService propertyDefService;

    @CacheEvict(value={"tplOrderItemDetail"}, allEntries=true)
    public void addObj(TplOrderItemDetail t) {
        Assert.isNotBlank((String)t.getCode(), (String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        TplOrderItemDetailExample example = new TplOrderItemDetailExample();
        example.createCriteria().andCodeEqualTo(t.getCode()).andIsHisEqualTo(Constant.NO_INT);
        if (this.tplOrderItemDetailMapper.countByExample(example) > 0) {
            throw new CommonException("\u7f16\u7801\u5df2\u5b58\u5728");
        }
        this.tplOrderItemDetailMapper.insertSelective(t);
    }

    @CacheEvict(value={"tplOrderItemDetail"}, allEntries=true)
    public void deleteObjById(String id) {
        this.tplOrderItemDetailMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"tplOrderItemDetail"}, allEntries=true)
    public void modifyObj(TplOrderItemDetail t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        if (t.getCode() != null) {
            TplOrderItemDetailExample example = new TplOrderItemDetailExample();
            example.createCriteria().andCodeEqualTo(t.getCode()).andIdNotEqualTo(t.getId()).andIsHisEqualTo(Constant.NO_INT);
            if (this.tplOrderItemDetailMapper.countByExample(example) > 0) {
                throw new CommonException("\u7f16\u7801\u5df2\u5b58\u5728");
            }
        }
        this.tplOrderItemDetailMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"tplOrderItemDetail"}, keyGenerator="redisKeyGenerator")
    public TplOrderItemDetail queryObjById(String id) {
        TplOrderItemDetail tplOrderItemDetail = this.tplOrderItemDetailMapper.selectByPrimaryKey(id);
        if (tplOrderItemDetail == null) {
            return null;
        }
        if (!Constant.YES_INT.equals(tplOrderItemDetail.getIsHis())) {
            tplOrderItemDetail.setPropertyDefList(PropertyDefUtils.queryOrderItemDetailProDef(tplOrderItemDetail));
        } else {
            List<PropertyDef> propertyDefList = this.propertyDefService.queryHisPropertyDefList(tplOrderItemDetail.getId(), PropertyDefTplType.ORDER_DETAIL_TYPE.getCode());
            tplOrderItemDetail.setPropertyDefList(propertyDefList);
        }
        return tplOrderItemDetail;
    }

    @Cacheable(value={"tplOrderItemDetail"}, keyGenerator="redisKeyGenerator")
    public List<TplOrderItemDetail> queryAllObjByExample(TplOrderItemDetailExample example) {
        return this.tplOrderItemDetailMapper.selectByExample(example);
    }

    @Cacheable(value={"tplOrderItemDetail"}, keyGenerator="redisKeyGenerator")
    public PageView<TplOrderItemDetail> queryObjByPage(TplOrderItemDetailExample example) {
        PageView<TplOrderItemDetail> pageView = example.getPageView();
        pageView.setQueryResult(this.tplOrderItemDetailMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Transactional
    @CacheEvict(value={"tplOrderItemDetail"}, allEntries=true)
    public void addAll(List<TplOrderItemDetail> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
                this.tplOrderItemDetailMapper.insertSelective((TplOrderItemDetail)item);
            }
        });
    }

    @CacheEvict(value={"tplOrderItemDetail"}, allEntries=true)
    public void deleteByExample(TplOrderItemDetailExample arg0) {
        Assert.isNotNull((Object)arg0, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(arg0.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.tplOrderItemDetailMapper.deleteByExample(arg0);
    }
}

