/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.utils;

import com.els.base.core.entity.dictionary.DicGroupItem;
import com.els.base.core.service.dictionary.DicGroupItemService;
import com.els.base.utils.SpringContextHolder;
import io.swagger.annotations.ApiModelProperty;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;

public class DicGroupConvertorUtils {
    private static final String DATA_TYPE = "dic_group";

    public static void code2Value(Object instance, Map<String, String> backupCodeValue) throws IllegalArgumentException, IllegalAccessException {
        if (instance == null) {
            return;
        }
        Class<?> clazz = instance.getClass();
        for (Field field : clazz.getDeclaredFields()) {
            boolean accessible = field.isAccessible();
            field.setAccessible(true);
            DicGroupConvertorUtils.setFieldActualValue(field, instance, backupCodeValue);
            field.setAccessible(accessible);
        }
    }

    private static void setFieldActualValue(Field field, Object instance, Map<String, String> backupCodeValue) throws IllegalArgumentException, IllegalAccessException {
        Optional<ApiModelProperty> annotationOpt = Optional.ofNullable(field.getAnnotation(ApiModelProperty.class));
        annotationOpt = annotationOpt.filter(annotation -> DATA_TYPE.equals(annotation.dataType())).filter(annotation -> StringUtils.isNotEmpty((String)annotation.notes()));
        Optional<Object> dicGroupItemServiceOpt = Optional.ofNullable(SpringContextHolder.getOneBean(DicGroupItemService.class));
        Optional<String> codeValueOpt = Optional.ofNullable(String.valueOf(field.get(instance)));
        if (!codeValueOpt.isPresent()) {
            codeValueOpt = Optional.ofNullable(DicGroupConvertorUtils.getCodeFromBackupItemCodeMap(field, backupCodeValue));
        }
        if (!annotationOpt.isPresent() || !codeValueOpt.isPresent()) {
            return;
        }
        String groupCode = annotationOpt.get().notes();
        String groupItemCode = codeValueOpt.get();
        if (StringUtils.isBlank((String)groupCode) || StringUtils.isBlank((String)groupItemCode)) {
            return;
        }
        Optional<DicGroupItem> dicItemOpt = dicGroupItemServiceOpt.map(itemService -> itemService.queryItems(groupCode, groupItemCode));
        if (dicItemOpt.isPresent()) {
            field.set(instance, dicItemOpt.get().getName());
        }
    }

    private static String getCodeFromBackupItemCodeMap(Field field, Map<String, String> backupItemCode) {
        return backupItemCode == null ? null : backupItemCode.get(field.getName());
    }
}

