/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.utils;

import com.els.base.company.entity.Company;
import com.els.base.core.entity.user.User;
import com.els.base.core.utils.Assert;
import com.els.base.inquiry.entity.InquirySupOrder;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.enumclass.ExcelTemplatePathEnum;
import java.util.HashMap;
import java.util.Map;

public class ExportParam {
    private Map<String, Object> valMap;
    private ExcelTemplatePathEnum pathEnum;

    public ExportParam() {
    }

    public ExportParam(Map<String, Object> valMap, ExcelTemplatePathEnum pathEnum) {
        this.valMap = valMap;
        this.pathEnum = pathEnum;
    }

    public static Builder create(ExcelTemplatePathEnum pathEnum) {
        return new Builder(pathEnum);
    }

    public Map<String, Object> getValMap() {
        return this.valMap;
    }

    public ExcelTemplatePathEnum getPathEnum() {
        return this.pathEnum;
    }

    public static class Builder {
        private InquirySupOrder supOrder;
        private TemplateConf templateConf;
        private Company supCompany;
        private User purUser;
        private Map<String, Object> other;
        private ExcelTemplatePathEnum pathEnum;
        private Map<String, Object> valMap = new HashMap<String, Object>(16);

        public Builder(ExcelTemplatePathEnum pathEnum) {
            this.pathEnum = pathEnum;
        }

        public ExportParam build() {
            Assert.isNotNull((Object)((Object)this.pathEnum), (String)"excel\u6a21\u5757\u6587\u4ef6\u5730\u5740\u5fc5\u987b\u8bbe\u7f6e");
            this.valMap.put("supOrder", this.supOrder);
            this.valMap.put("templateConf", this.templateConf);
            this.valMap.put("supCompany", this.supCompany);
            this.valMap.put("purUser", this.purUser);
            this.valMap.put("other", this.other);
            switch (this.pathEnum) {
                case ELECTRONIC: {
                    break;
                }
                case PLASTIC: {
                    break;
                }
                case STRUCTURE: {
                    break;
                }
            }
            return new ExportParam(this.valMap, this.pathEnum);
        }

        public Builder setSupOrder(InquirySupOrder supOrder) {
            this.supOrder = supOrder;
            return this;
        }

        public Builder setTemplateConf(TemplateConf templateConf) {
            this.templateConf = templateConf;
            return this;
        }

        public Builder setSupCompany(Company supCompany) {
            this.supCompany = supCompany;
            return this;
        }

        public Builder setPurUser(User purUser) {
            this.purUser = purUser;
            return this;
        }

        public Builder setOther(Map<String, Object> other) {
            this.other = other;
            return this;
        }

        public Builder setPathEnum(ExcelTemplatePathEnum pathEnum) {
            this.pathEnum = pathEnum;
            return this;
        }
    }
}

