/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.inquiry.web.controller;

import com.els.base.auth.utils.AuthConstant;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.ResponseCode;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.inquiry.IOrderItem;
import com.els.base.inquiry.IOrderItemDetail;
import com.els.base.inquiry.ITarget;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.command.pur.ApproveSubmitCommand;
import com.els.base.inquiry.command.pur.BatchDeleteCommand;
import com.els.base.inquiry.command.pur.BatchPricingOrderCommand;
import com.els.base.inquiry.command.pur.BatchPublishCommand;
import com.els.base.inquiry.command.pur.BatchReQuoteCommand;
import com.els.base.inquiry.command.pur.BatchSyncPriceToSapCmd;
import com.els.base.inquiry.command.pur.CancelCommand;
import com.els.base.inquiry.command.pur.CreateCommand;
import com.els.base.inquiry.command.pur.ModifyCommand;
import com.els.base.inquiry.command.pur.PreviewCommand;
import com.els.base.inquiry.command.pur.PreviewTargeListByWaitCommand;
import com.els.base.inquiry.command.pur.PreviewTargeListCommand;
import com.els.base.inquiry.command.pur.PricingCommand;
import com.els.base.inquiry.command.pur.PricingOrderCommand;
import com.els.base.inquiry.command.pur.PublishCommand;
import com.els.base.inquiry.command.pur.RecallCommand;
import com.els.base.inquiry.command.pur.SelectSupPricingCommand;
import com.els.base.inquiry.command.pur.UpdateMaterialCodeCmd;
import com.els.base.inquiry.command.pur.ViewDetailCommand;
import com.els.base.inquiry.command.pur.ViewPricingDetailCommand;
import com.els.base.inquiry.entity.InquiryQuoteLadder;
import com.els.base.inquiry.entity.PropertyValue;
import com.els.base.inquiry.entity.PurOrder;
import com.els.base.inquiry.entity.PurOrderExample;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.service.PurOrderService;
import com.els.base.inquiry.service.TemplateConfService;
import com.els.base.inquiry.utils.LaddPriceValider;
import com.els.base.inquiry.utils.json.DetailDeSerializer;
import com.els.base.inquiry.utils.json.DetailSerialzer;
import com.els.base.inquiry.web.vo.ApproveSubmitVo;
import com.els.base.inquiry.web.vo.MaterialTransformVo;
import com.els.base.inquiry.web.vo.OrderItemVo;
import com.els.base.inquiry.web.vo.WaitMaterialTransformVo;
import com.els.base.material.entity.Material;
import com.els.base.material.entity.MaterialExample;
import com.els.base.material.service.MaterialService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u8be2\u62a5\u4ef7-\u91c7\u8d2d\u65b9-\u8868\u5934"})
@Controller
@RequestMapping(value={"purOrder"})
public class PurOrderController {
    @Resource
    protected InquiryCommandInvoker invoker;
    @Resource
    protected PurOrderService purOrderService;
    @Resource
    private MaterialService materialService;
    @Resource
    private TemplateConfService templateConfService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u8be2\u62a5\u4ef7-\u91c7\u8d2d\u65b9-\u8868\u5934")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody PurOrder purOrder) {
        CreateCommand cmd = new CreateCommand(purOrder);
        cmd.setPurUser(SpringSecurityUtils.getLoginUser());
        cmd.setPurCompany(CompanyUtils.currentCompany());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u8be2\u62a5\u4ef7-\u91c7\u8d2d\u65b9-\u8868\u5934")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody PurOrder purOrder) {
        Assert.isNotBlank((String)purOrder.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        ModifyCommand cmd = new ModifyCommand(purOrder);
        cmd.setPurUser(SpringSecurityUtils.getLoginUser());
        cmd.setPurCompany(CompanyUtils.currentCompany());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u8be2\u62a5\u4ef7-\u91c7\u8d2d\u65b9-\u8868\u5934")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank((String)id, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.purOrderService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u8be2\u62a5\u4ef7-\u91c7\u8d2d\u65b9-\u8868\u5934")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PurOrder", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<PurOrder>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        PurOrderExample example = new PurOrderExample();
        example.setPageView((PageView<PurOrder>)new PageView(pageNo, pageSize));
        example.setOrderByClause(" CREATE_DATE DESC");
        List roleCodeList = SpringSecurityUtils.getLoginUserRoleIdList();
        if (CollectionUtils.isEmpty((Collection)roleCodeList) || !roleCodeList.contains(AuthConstant.SYS_MANAGER_ROLE.getRoleCode())) {
            example.createCriteria().andPurUserIdEqualTo(SpringSecurityUtils.getLoginUserId());
        }
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.purOrderService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u8be2\u62a5\u4ef7\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", required=false, value="\u8be2\u4ef7\u5355id", paramType="query", dataType="String", defaultValue="0")})
    @RequestMapping(value={"service/findById"})
    @ResponseBody
    public ResponseResult<PurOrder> findById(@RequestParam(required=true) String id) {
        PurOrder order = (PurOrder)this.purOrderService.queryObjById(id);
        Assert.isNotNull((Object)order, (String)"\u8be2\u4ef7\u5355\u4e0d\u5b58\u5728");
        return this.viewPricingDetail(id);
    }

    @ApiOperation(httpMethod="POST", value="\u9884\u89c8\u8868\u5934")
    @RequestMapping(value={"service/preview"})
    @ResponseBody
    public ResponseResult<PurOrder> preview(@RequestBody(required=true) WaitMaterialTransformVo vo) {
        PreviewCommand cmd = new PreviewCommand(vo.getTemplateId(), vo.getMaterials());
        cmd.setPurCompany(CompanyUtils.currentCompany());
        cmd.setPurUser(SpringSecurityUtils.getLoginUser());
        PurOrder order = this.invoker.invoke(cmd);
        return ResponseResult.success((Object)order);
    }

    @ApiOperation(httpMethod="POST", value="\u9884\u89c8\u8868\u884c")
    @RequestMapping(value={"service/previewTargetByWait"})
    @ResponseBody
    public ResponseResult<List<ITarget>> previewTargetByWait(@RequestBody(required=true) WaitMaterialTransformVo vo) {
        PreviewTargeListByWaitCommand cmd = new PreviewTargeListByWaitCommand(vo.getTemplateId(), vo.getMaterials());
        cmd.setPurCompany(CompanyUtils.currentCompany());
        cmd.setPurUser(SpringSecurityUtils.getLoginUser());
        return ResponseResult.success(this.invoker.invoke(cmd));
    }

    @ApiOperation(httpMethod="POST", value="\u9884\u89c8\u8868\u884c")
    @RequestMapping(value={"service/previewTarget"})
    @ResponseBody
    public ResponseResult<List<ITarget>> previewTarget(@RequestBody(required=true) MaterialTransformVo vo) {
        PreviewTargeListCommand cmd = new PreviewTargeListCommand(vo.getTemplateId(), vo.getMaterials());
        cmd.setPurCompany(CompanyUtils.currentCompany());
        cmd.setPurUser(SpringSecurityUtils.getLoginUser());
        return ResponseResult.success(this.invoker.invoke(cmd));
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u770b\u8be6\u60c5\u754c\u9762")
    @RequestMapping(value={"service/viewDetail"})
    @ResponseBody
    public ResponseResult<PurOrder> viewDetail(@RequestParam(required=true) String purOrderId) {
        ViewDetailCommand cmd = new ViewDetailCommand(purOrderId);
        cmd.setPurUser(SpringSecurityUtils.getLoginUser());
        cmd.setPurCompany(CompanyUtils.currentCompany());
        PurOrder order = this.invoker.invoke(cmd);
        return ResponseResult.success((Object)order);
    }

    @ApiOperation(httpMethod="POST", value="\u53d1\u5e03\u8be2\u4ef7\u5355")
    @RequestMapping(value={"service/publish"})
    @ResponseBody
    public ResponseResult<String> publish(@RequestBody PurOrder purOrder) {
        PublishCommand cmd = new PublishCommand(purOrder);
        cmd.setPurUser(SpringSecurityUtils.getLoginUser());
        cmd.setPurCompany(CompanyUtils.currentCompany());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u53d1\u5e03\u8be2\u4ef7\u5355")
    @RequestMapping(value={"service/batchPublish"})
    @ResponseBody
    public ResponseResult<String> batchPublish(@RequestBody(required=true) List<String> ids) {
        BatchPublishCommand cmd = new BatchPublishCommand(ids);
        cmd.setPurUser(SpringSecurityUtils.getLoginUser());
        cmd.setPurCompany(CompanyUtils.currentCompany());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u65b9\u6279\u91cf\u64a4\u56de\u8be2\u4ef7\u5355")
    @RequestMapping(value={"service/batchRecall"})
    @ResponseBody
    public ResponseResult<String> batchRecall(@RequestBody(required=true) List<String> ids) {
        RecallCommand cmd = new RecallCommand(ids);
        cmd.setPurUser(SpringSecurityUtils.getLoginUser());
        cmd.setPurCompany(CompanyUtils.currentCompany());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u65b9\u6279\u91cf\u4f5c\u5e9f\u8be2\u4ef7\u5355")
    @RequestMapping(value={"service/batchCancel"})
    @ResponseBody
    public ResponseResult<String> batchCancel(@RequestBody(required=true) List<String> ids, String digestExplain) {
        CancelCommand cmd = new CancelCommand(ids, digestExplain);
        cmd.setPurUser(SpringSecurityUtils.getLoginUser());
        cmd.setPurCompany(CompanyUtils.currentCompany());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u65b9\u6279\u91cf\u5220\u9664\u8be2\u4ef7\u5355")
    @RequestMapping(value={"service/batchDelete"})
    @ResponseBody
    public ResponseResult<String> batchDelete(@RequestBody(required=true) List<String> ids) {
        BatchDeleteCommand cmd = new BatchDeleteCommand(ids);
        cmd.setPurUser(SpringSecurityUtils.getLoginUser());
        cmd.setPurCompany(CompanyUtils.currentCompany());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u770b\u5b9a\u4ef7\u8be6\u60c5\u754c\u9762")
    @RequestMapping(value={"service/viewPricingDetail"})
    @ResponseBody
    public ResponseResult<PurOrder> viewPricingDetail(@RequestParam(required=true) String purOrderId) {
        ViewPricingDetailCommand cmd = new ViewPricingDetailCommand(purOrderId);
        PurOrder purOrder = this.invoker.invoke(cmd);
        cmd.setPurUser(SpringSecurityUtils.getLoginUser());
        cmd.setPurCompany(CompanyUtils.currentCompany());
        return ResponseResult.success((Object)purOrder);
    }

    @ApiOperation(httpMethod="POST", value="\u5b9a\u4ef7\u4fdd\u5b58")
    @RequestMapping(value={"service/pricing"})
    @ResponseBody
    public ResponseResult<String> pricing(@RequestBody(required=true) PurOrder purOrder) {
        PricingCommand cmd = new PricingCommand(purOrder);
        cmd.setPurUser(SpringSecurityUtils.getLoginUser());
        cmd.setPurCompany(CompanyUtils.currentCompany());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u6267\u884c\u91cd\u62a5\u4ef7\u64cd\u4f5c")
    @RequestMapping(value={"service/batchReQuote"})
    @ResponseBody
    public ResponseResult<String> batchReQuote(@RequestBody(required=true) OrderItemVo orderItemVo) {
        TemplateConf templateConf = (TemplateConf)this.templateConfService.queryObjById(orderItemVo.getTemplateId());
        IOrderItem orderItem = (IOrderItem)templateConf.getOrderItemService().queryObjById(orderItemVo.getId());
        orderItem.setPurRemark(orderItemVo.getPurRemark());
        BatchReQuoteCommand cmd = new BatchReQuoteCommand(Arrays.asList(orderItem));
        cmd.setPurUser(SpringSecurityUtils.getLoginUser());
        cmd.setPurCompany(CompanyUtils.currentCompany());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u63d0\u4ea4\u5ba1\u6279")
    @RequestMapping(value={"service/submitToApprove"})
    @ResponseBody
    public ResponseResult<String> submitToApprove(@RequestBody(required=true) ApproveSubmitVo vo) {
        ApproveSubmitCommand cmd = new ApproveSubmitCommand(vo);
        cmd.setPurUser(SpringSecurityUtils.getLoginUser());
        cmd.setPurCompany(CompanyUtils.currentCompany());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u8ba1\u7b97\u4e0d\u542b\u7a0e\u4ef7\u683c")
    @RequestMapping(value={"service/calculateItemDetail"})
    @ResponseBody
    public ResponseResult<BigDecimal> calculateItemDetail(@RequestParam(required=true) String templateId, @RequestBody List<PropertyValue> propertyValueList) throws InstantiationException, IllegalAccessException {
        TemplateConf templateConf = (TemplateConf)this.templateConfService.queryObjById(templateId);
        DetailDeSerializer<? extends IOrderItemDetail> serializer = new DetailDeSerializer<IOrderItemDetail>(templateConf.getTplOrderItemDetail().getOrderItemDetailClass());
        IOrderItemDetail itemDetail = serializer.transform(propertyValueList);
        return ResponseResult.success((Object)itemDetail.calculate());
    }

    @ApiOperation(httpMethod="POST", value="\u8ba1\u7b97\u4e0d\u542b\u7a0e\u4ef7\u683c")
    @RequestMapping(value={"service/calculateItemDetailValue"})
    @ResponseBody
    public ResponseResult<List<PropertyValue>> calculateItemDetailValue(@RequestParam(required=true) String templateId, @RequestBody List<PropertyValue> propertyValueList) throws InstantiationException, IllegalAccessException {
        TemplateConf templateConf = (TemplateConf)this.templateConfService.queryObjById(templateId);
        DetailDeSerializer<? extends IOrderItemDetail> detailDeSerializer = new DetailDeSerializer<IOrderItemDetail>(templateConf.getTplOrderItemDetail().getOrderItemDetailClass());
        IOrderItemDetail itemDetail = detailDeSerializer.transform(propertyValueList);
        itemDetail.calculate();
        itemDetail.setTemplateId(templateConf.getTplOrderItemDetail().getId());
        DetailSerialzer<IOrderItemDetail> serialzer = new DetailSerialzer<IOrderItemDetail>();
        return ResponseResult.success(serialzer.getProperyValueClass(itemDetail));
    }

    @ApiOperation(httpMethod="POST", value="\u9009\u53d6\u4f9b\u5e94\u5546\u6bd4\u4ef7\u754c\u9762")
    @RequestMapping(value={"service/selectSupPriceParity"})
    @ResponseBody
    public ResponseResult<Map<String, Object>> selectSupPriceParity(@RequestParam(required=true) String purOrderId, @RequestBody List<String> supplierIds) {
        if (supplierIds.size() < 2) {
            throw new CommonException("\u8bf7\u52fe\u9009\u4e24\u4e2a\u4ee5\u4e0a");
        }
        SelectSupPricingCommand cmd = new SelectSupPricingCommand(supplierIds, purOrderId);
        Map<String, Object> materialAndPrice = this.invoker.invoke(cmd);
        return ResponseResult.success(materialAndPrice);
    }

    @ApiOperation(httpMethod="POST", value="\u4fdd\u5b58-\u9636\u68af\u8bbe\u7f6e")
    @RequestMapping(value={"service/saveLadder"})
    @ResponseBody
    public ResponseResult<String> saveLadder(@RequestBody List<InquiryQuoteLadder> inquiryQuoteLadders) {
        LaddPriceValider.valid(inquiryQuoteLadders);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6839\u636e\u7269\u6599\u7f16\u7801\u67e5\u8be2\u7269\u6599\u63cf\u8ff0")
    @RequestMapping(value={"service/findMaterialDescByCode"})
    @ResponseBody
    public ResponseResult<String> findMaterialDescByCode(@RequestParam(required=false) String materialCode) {
        String materialDesc = "";
        if (StringUtils.isBlank((String)materialCode)) {
            return ResponseResult.success((Object)materialDesc);
        }
        MaterialExample materialExample = new MaterialExample();
        materialExample.createCriteria().andMaterialCodeEqualTo(materialCode);
        List materials = this.materialService.queryAllObjByExample((IExample)materialExample);
        if (CollectionUtils.isNotEmpty((Collection)materials) && StringUtils.isNotBlank((String)((Material)materials.get(0)).getDescription())) {
            materialDesc = ((Material)materials.get(0)).getDescription();
        }
        return ResponseResult.success((Object)materialDesc);
    }

    @ApiOperation(httpMethod="POST", value="\u5c06\u8be2\u4ef7\u5355\u884c\u5bfc\u5165sap\u7cfb\u7edf")
    @RequestMapping(value={"service/syncPriceToSap"})
    @ResponseBody
    public ResponseResult<String> syncPriceToSap(@RequestBody List<OrderItemVo> vos) {
        Assert.isNotEmpty(vos, (String)"\u8be2\u4ef7\u5355\u4e0d\u5b58\u5728");
        BatchSyncPriceToSapCmd cmd = new BatchSyncPriceToSapCmd(vos);
        cmd.setPurUser(SpringSecurityUtils.getLoginUser());
        cmd.setPurCompany(CompanyUtils.currentCompany());
        List<IOrderItem> failItem = this.invoker.invoke(cmd);
        if (CollectionUtils.isNotEmpty(failItem)) {
            ResponseResult r = new ResponseResult().setCode(ResponseCode.Fail.getCode());
            List reasons = failItem.stream().map(IOrderItem::getFailReason).distinct().collect(Collectors.toList());
            if (reasons.size() < 3) {
                r.setMsg(String.format("\u64cd\u4f5c\u5931\u8d25,\u5931\u8d25\u539f\u56e0:%s", StringUtils.join(reasons, (String)",")));
                return r;
            }
            Map<String, List<IOrderItem>> materialGroup = failItem.stream().collect(Collectors.groupingBy(IOrderItem::getMaterialDesc));
            String allWarnStr = materialGroup.keySet().stream().map(materialDesc -> {
                List tmpList = (List)materialGroup.get(materialDesc);
                String supNameStr = tmpList.stream().map(IOrderItem::getSupCompanyName).distinct().collect(Collectors.joining(","));
                String warnStr = String.format("\u7269\u6599 %s \u62a5\u4ef7\u4e2d\uff0c\u4ee5\u4e0b\u4f9b\u5e94\u5546\u62a5\u4ef7\u56de\u5199\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\u8bb0\u5f55\u5728\u62a5\u4ef7\u660e\u7ec6\u4e2d\u3002\u4f9b\u5e94\u5546:[%s]", materialDesc, supNameStr);
                return warnStr;
            }).collect(Collectors.joining("/n"));
            return r.setMsg(allWarnStr);
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6839\u636e\u7269\u6599\u6e05\u5355\uff0c\u4fee\u6539\u7269\u6599\u7f16\u7801")
    @RequestMapping(value={"service/modifyMaterialCodeByTarget"})
    @ResponseBody
    public ResponseResult<String> modifyMaterialCodeByTarget(@RequestParam(required=true) String targetId, @RequestParam(required=true) String materialCode, @RequestParam(required=true) String orderId) {
        UpdateMaterialCodeCmd cmd = new UpdateMaterialCodeCmd(targetId, materialCode, orderId);
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u63d0\u4ea4\u8be2\u4ef7\u5355")
    @RequestMapping(value={"service/submitInquiryOrder"})
    @ResponseBody
    public ResponseResult<String> submitInquiryOrder(@RequestBody List<String> orderIdList) {
        Assert.isNotEmpty(orderIdList, (String)"\u8bf7\u9009\u62e9\u9700\u8981\u63d0\u4ea4\u7684\u5355\u636e");
        PurOrder purOrder = new PurOrder();
        orderIdList.forEach(id -> {
            purOrder.setId((String)id);
            purOrder.setSubmitStatus(Constant.YES_INT.toString());
            this.purOrderService.modifyObj(purOrder);
        });
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u8be2\u4ef7\u5355\u5b9a\u4ef7")
    @RequestMapping(value={"service/pricingOrder"})
    @ResponseBody
    public ResponseResult<String> pricingOrder(@RequestBody(required=true) PurOrder purOrder) {
        PricingOrderCommand cmd = new PricingOrderCommand(purOrder);
        cmd.setPurUser(SpringSecurityUtils.getLoginUser());
        cmd.setPurCompany(CompanyUtils.currentCompany());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u5b9a\u4ef7\u8be2\u4ef7\u5355")
    @RequestMapping(value={"service/batchPricingOrder"})
    @ResponseBody
    public ResponseResult<String> batchPricingOrder(@RequestBody(required=true) List<String> ids) {
        BatchPricingOrderCommand cmd = new BatchPricingOrderCommand(ids);
        cmd.setPurUser(SpringSecurityUtils.getLoginUser());
        cmd.setPurCompany(CompanyUtils.currentCompany());
        this.invoker.invoke(cmd);
        return ResponseResult.success();
    }
}

