package com.els.base.inquiry;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.els.base.company.entity.Company;
import com.els.base.core.entity.user.User;

public abstract class AbstractInquiryCommand<Result> {
	
	protected Logger logger = LoggerFactory.getLogger(this.getClass());
	
	private User supUser;
	private User purUser;
	private Company supCompany;
	private Company purCompany;
	protected InquiryCommandInvoker invoker;
	
	public abstract Result execute(InquiryCommandInvoker invoker);

	public User getSupUser() {
		return supUser;
	}

	public void setSupUser(User supUser) {
		this.supUser = supUser;
	}

	public User getPurUser() {
		return purUser;
	}

	public void setPurUser(User purUser) {
		this.purUser = purUser;
	}

	public Company getSupCompany() {
		return supCompany;
	}

	public void setSupCompany(Company supCompany) {
		this.supCompany = supCompany;
	}

	public Company getPurCompany() {
		return purCompany;
	}

	public void setPurCompany(Company purCompany) {
		this.purCompany = purCompany;
	}
	
	public InquiryCommandInvoker getInvoker() {
		return invoker;
	}

	public void setInvoker(InquiryCommandInvoker invoker) {
		this.invoker = invoker;
	}

	@SuppressWarnings("rawtypes")
	public void copyProperties(AbstractInquiryCommand src){
		this.setSupUser(src.getSupUser());
		this.setPurUser(src.getPurUser());
		this.setSupCompany(src.getSupCompany());
		this.setPurCompany(src.getPurCompany());
		this.invoker = src.invoker;
	}
	
}
