package com.els.base.inquiry;

import java.util.List;

import com.els.base.inquiry.entity.InquiryQuoteLadder;
import com.els.base.mould.master.entity.Mould;

import io.swagger.annotations.ApiModelProperty;

public abstract class AbstractOrderItem implements IOrderItem {
	
	private static final long serialVersionUID = 1L;
	
	@ApiModelProperty(value="物料模具", dataType="button", position=29)
	private List<Mould> materialMouldList;
	
	@ApiModelProperty(value="设置阶梯", dataType="button", position=21)
 	private List<InquiryQuoteLadder> inquiryQuoteLadders;
	
	@ApiModelProperty(hidden=true,position=24,value="物料成本清单",dataType="button")
	private IOrderItemDetail orderItemDetail;
	
	@Override
	public List<InquiryQuoteLadder> getInquiryQuoteLadders() {
		return inquiryQuoteLadders;
	}

	@Override
	public void setInquiryQuoteLadders(List<InquiryQuoteLadder> inquiryQuoteLadders) {
		this.inquiryQuoteLadders = inquiryQuoteLadders;
	}

	@Override
	public void setOrderItemDetail(IOrderItemDetail orderItemDetail){
		this.orderItemDetail = orderItemDetail;
	}

	public List<Mould> getMaterialMouldList() {
		return materialMouldList;
	}

	public void setMaterialMouldList(List<Mould> materialMouldList) {
		this.materialMouldList = materialMouldList;
	}

	@Override
	public IOrderItemDetail getOrderItemDetail() {
		return orderItemDetail;
	}
	
}
