package com.els.base.inquiry;

import java.util.List;

import org.apache.commons.lang.StringUtils;

import com.els.base.inquiry.entity.PropertyDef;
import com.els.base.inquiry.entity.PropertyValue;
import com.els.base.inquiry.entity.TplOrderItemDetail;
import com.els.base.inquiry.service.TplOrderItemDetailService;
import com.els.base.inquiry.utils.PropertyDefUtils;
import com.els.base.utils.SpringContextHolder;

public abstract class AbstractOrderItemDetail implements IOrderItemDetail {
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private List<PropertyValue> propertyValueList;
	
	@Override
	public List<PropertyValue> getPropertyValueList() {
		return this.propertyValueList;
	}

	@Override
	public void setPropertyValueList(List<PropertyValue> propertyValueList) {
		this.propertyValueList = propertyValueList;
	}

	@Override
	public List<PropertyDef> getPropertyDefList() {
		if (StringUtils.isNotBlank(this.getTemplateId())) {
			TplOrderItemDetail tplOrderItemDetail = SpringContextHolder.getOneBean(TplOrderItemDetailService.class).queryObjById(this.getTemplateId());
			
			if (tplOrderItemDetail != null) {
				return tplOrderItemDetail.getPropertyDefList();
			}
			
		}
		
		return PropertyDefUtils.getProperyDefByClass(this.getClass());
	}
	
}
