package com.els.base.inquiry;

import java.io.Serializable;
import java.util.List;

import com.els.base.inquiry.entity.PropertyDef;
import com.els.base.inquiry.entity.PropertyValue;

/**
 * 可自定义字段的接口，加上这个接口，表示这个类型具有可自定义字段的功能
 * @author hzy
 *
 */
public interface IExtendable extends Serializable {
	public String getId();
	
	/**
	 * 物料清单里面的自定义字段的值
	 * @return
	 */
	public List<PropertyValue> getPropertyValueList();
	
	/**
	 * 设置物料清单里面的自定义字段的值
	 * @param propertyValueList
	 */
	public void setPropertyValueList(List<PropertyValue> propertyValueList);
	
	/**
	 * 物料清单里面的自定义字段
	 * @return
	 */
	public List<PropertyDef> getPropertyDefList();

}
