package com.els.base.inquiry;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import com.els.base.inquiry.entity.InquiryQuoteLadder;
import com.els.base.inquiry.entity.InquirySupOrder;
import com.els.base.inquiry.entity.PurOrder;

/**
 * 询价单行
 * @author hzy
 *
 */
public interface IOrderItem extends Serializable, IExtendable {
	
	public static final Integer CANCEL_OPERATION = -1;
	
	/**
	 * 获取行id
	 * @return
	 */
    public String getId();
	
    /**
     * 获取是否无法报价
     * @return
     */
	public Integer getUnableToQuote();
	
	/**
	 * 是否还包含关联子表
	 * @return
	 */
	public Integer getIsOrderItemDetailEnable();
	
	/**
	 * 未含税单价
	 * @return
	 * @throws ClassNotFoundException 
	 */
	public BigDecimal getUntaxedUnitPrice();
	
	/**
	 * 设置物料成本清单
	 * @return
	 */
	public void setOrderItemDetail(IOrderItemDetail detail);
	/**
	 * 获取物料成本清单
	 * @return
	 * @throws ClassNotFoundException 
	 */
	public IOrderItemDetail getOrderItemDetail();
	
	/**
	 * 获取报价状态
	 * @return
	 */
	public Integer getQuotationStatus();
	
	/**
	 * 获取供应商表头ID，来查询商务条件里的税率，计算明细表的不含税单价和含税单价。
	 * @return
	 */
	public String getSupOrderId();

	/**
	 * 设置报价状态
	 * @param quotationStatus
	 */
	public void setQuotationStatus(Integer quotationStatus);
	
	/**
	 * 设置接受或拒绝操作
	 * @return
	 */
	public Integer getOperation();

	/**
	 * 获取报价人id
	 * @return
	 */
	String getSupUserId();
	
	/**
	 * 获取物料编码
	 * @return
	 */
	public String getMaterialCode();
	
	public IOrderItem build(PurOrder order, InquirySupOrder supOrder, ITarget target);

	public void setInquiryQuoteLadders(List<InquiryQuoteLadder> orderLadderList);
	
	public List<InquiryQuoteLadder> getInquiryQuoteLadders();

	String getTargetId();

	String getSupCompanyName();

	String getSupCompanySapCode();

	String getSupCompanyId();

	void setOrderItemNo(Integer orderItemNo);

	void setSupUserId(String supUserId);

	void setSupUserName(String supUserName);

	String getSupUserName();

	public void setId(String id);

	public String getPurOrderId();

	public void setOperation(Integer operation);

	String getTemplateId();

	public Class<? extends IOrderItemService> getOrderItemService();

	public void setUntaxedUnitPrice(BigDecimal calculate);

	Integer getQuoteType();

	void setQuoteType(Integer quoteType);

	Date getQuoteTime();

	void setQuoteTime(Date quoteTime);

	void setSupOrderId(String supOrderId);

	void setPurOrderId(String purOrderId);

	/**
	 * 校验是否能报价
	 */
	public void isVaildForQuote();

	/**
	 * 设置物料编码
	 * @param materialCode
	 */
	void setMaterialCode(String materialCode);
	
	public Integer getPlanDeliveryDate(); 

}
