package com.els.base.inquiry;

import java.math.BigDecimal;

/**
 * 物料成本清单
 * @author hzy
 *
 */
public interface IOrderItemDetail extends ICalculateStrategy, IExtendable {
	
	public void setUntaxedUnitPrice(BigDecimal untaxedUnitPrice);
	
	public BigDecimal getUntaxedUnitPrice();

	String getOrderItemId();

	void setOrderItemId(String orderItemId);
	
	String getTemplateId();

	void setTaxUnitPrice(BigDecimal taxUnitPrice);

	BigDecimal getTaxUnitPrice();

	void setTemplateId(String templateId);

	String getMaterialCode();

	void setMaterialCode(String materialCode);

	String getMaterialDesc();

	void setMaterialDesc(String materialDesc);
	
	Class<? extends IOrderItemDetailService> getItemDetailService();

	/**
	 * 根据物料报价行，初始化物料成本分析清单的详情
	 * @param item
	 */
	public void build(IOrderItem item);

}
