package com.els.base.inquiry;

import java.util.List;

import com.els.base.core.entity.IExample;
import com.els.base.core.service.BaseService;

public interface IOrderItemDetailService<T extends IOrderItemDetail, Example extends IExample<T>, Id extends Object>  extends BaseService<T, Example, Id>, IExtendableService{

	/**
	 * 根据询价单行，返回物料成本明细
	 * @param id
	 * @return
	 */
	IOrderItemDetail queryObjByOrderItemId(String itemId);

	/**
	 * 根据订单行id ，删除物料成本清单
	 * @param orderItemIdList
	 */
	void deleteByOrderItemIds(List<String> orderItemIdList);

	/**
	 * 批量增加物料成本清单
	 * @param detailList
	 */
	void addAll(List<T> detailList);

}
