package com.els.base.inquiry;

import java.util.List;

import com.els.base.core.entity.IExample;
import com.els.base.core.service.BaseService;
import com.els.base.inquiry.entity.OrderItemM001;

public interface IOrderItemService<T extends IOrderItem, Example extends IExample<T>, Id extends Object>  extends BaseService<T, Example, Id>, IExtendableService{

	/**
	 * 根据采购方询价单号，查询询价目标清单，例如物料清单，模具清单
	 * @return
	 */
	public List<? extends IOrderItem> queryByPurOrderId(String purOrderId);
	
	/**
	 * 根据供应方询价单号，查询询价目标清单，例如物料清单，模具清单
	 * @return
	 */
	public List<T> queryBySupOrderId(String supOrderId);
	
	/**
	 * 根据供应商询价单头，保存的记录数为供应商询价单头和物料数量的乘积
	 * @param inquirySupOrders
	 * @param orderItems
	 */
//	public void batchInsertObj(List<InquirySupOrder> inquirySupOrders, List<ITarget> targets);

//	/**
//	 * 供应商报价时，需要批量更新询价单行项目
//	 * @param itemList
//	 */
//	public void batchModifyObj(User user, List<? extends IOrderItem> itemList);

	/**
	 * 根据询价单ID删除询价单行
	 */
	public void deleteByPurOrderId(String purOrderId);

	/**
	 * 采购方批量针对行项目执行重报价状态
	 * @param orderItem
	 */
//	public void reQuote(IOrderItem orderItem);

	/**
	 * 批量插入询价单行
	 * @param allOrderItemList
	 */
//	public void addAll(List<IOrderItem> allOrderItemList);

	/**
	 * 变更询价单行的状态
	 * @param tempItem
	 */
	public void modifyStatus(IOrderItem tempItem);

	/**
	 * 根据供应商询价单头，批量删除
	 * @param id
	 */
	public void deleteBySupOrderId(String id);

	/**
	 * 查询已经发布的订单行
	 * @param purOrderId
	 * @return 
	 */
	public List<OrderItemM001> queryPublishedItemByPurOrderId(String purOrderId);

}
