package com.els.base.inquiry;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import com.els.base.inquiry.entity.InquiryQuoteLadder;
import com.els.base.inquiry.entity.InquiryWaitMaterial;

/**
 * 询价目标,可以是物料，可以是模具，可以是其他要询价的对象
 * 
 * @author hzy
 *
 */
public interface ITarget extends Serializable, IExtendable {
	
	public static final String MATERIAL_TYPE_WAIT = "WaitMaterial";
	public static final String MATERIAL_TYPE_PROJECT = "ProjectMaterial";
	
	public String getId();
	
	 public String getOrderNo();
	 
	 public void setOrderNo(String orderNo);

	/**
	 * 获取模板id
	 * @return
	 */
	public String getTemplateId();
	
	/**
	 * 获取待询价物料id
	 * @return
	 */
	public String getWaitMaterialId();
	
	/**
	 * 根据设置带询价物料的属性到本身属性
	 * @param waitMaterial
	 */
	public void buildFromWaitMaterial(String templateId, InquiryWaitMaterial waitMaterial);
	
	/**
	 * 报价方式，1常规报价，2阶梯报价
	 * @return
	 */
	public Integer getQuoteType();

    public void setQuoteType(Integer quoteType);
    
    public List<InquiryQuoteLadder> getInquiryQuoteLadders();

	public void setInquiryQuoteLadders(List<InquiryQuoteLadder> inquiryQuoteLadders);

	public String getMaterialCode();

	public String getMapNo();
	
	public String getName();
	
	public Long getQuantity();
	
	public BigDecimal getRecentUntaxedUnitPrice();
	
	public String getDecreasingAmplitude();
	
	public String getPurchaseGroup();
	
	public BigDecimal getPurOrderQuantity();

	public BigDecimal getMinOrderQuantity();

	public Integer getPriceUnit();

	public Date getValidDateFrom();

	public Date getValidDateTo();

	public Integer getSortNo();

	String getPurOrderId();

	void setPurOrderId(String purOrderId);

	void setTemplateId(String templateId);

	void setSortNo(Integer sortNo);

	public Integer getOrderItemNo();

	public void setUnableToQuote(Integer object);

	public String getInfoCategory();

	public String getPurchaseApply();

	public String getProject();

	public void setMaterialCode(String materialCode);

	public void setQuantity(Long quantity);

	public void setMapNo(String figureType);

	public void setWaitMaterialId(String id);

	public void setRemark(String string);

	public void setMaterialType(String materialTypeProject);

}
