package com.els.base.inquiry;

import java.util.List;

import com.els.base.core.entity.IExample;
import com.els.base.core.service.BaseService;

public interface ITargetService<T extends ITarget, Example extends IExample<T>, Id extends Object> extends BaseService<T, Example, Id>, IExtendableService{
	
	/**
	 * 根据采购方询价单号，查询询价目标清单，例如物料清单，模具清单
	 * @return
	 */
	public List<ITarget> queryByPurOrderId(String purOrderId);

	/**
	 * 批量新增询价单物料
	 * @param order
	 * @param targetList
	 */
	public void addAll(List<T> targetList);
	
	/**
	 * 根据询价单id删除物料清单，同时删除阶梯报价记录
	 */
	public void deleteObjByPurOrderId(String purOrderId);

}
