package com.els.base.inquiry;

import javax.annotation.Resource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.inquiry.service.InformationRecordService;
import com.els.base.inquiry.service.InquiryBusiConditionService;
import com.els.base.inquiry.service.InquiryPurFileService;
import com.els.base.inquiry.service.InquiryQuoteLadderService;
import com.els.base.inquiry.service.InquirySupFileService;
import com.els.base.inquiry.service.InquirySupOrderService;
import com.els.base.inquiry.service.InquirySupplierService;
import com.els.base.inquiry.service.InquiryWaitMaterialService;
import com.els.base.inquiry.service.MaterielParityService;
import com.els.base.inquiry.service.MouldDetailService;
import com.els.base.inquiry.service.PropertyDefService;
import com.els.base.inquiry.service.PropertyValueService;
import com.els.base.inquiry.service.PurOrderService;
import com.els.base.inquiry.service.SystemPriceService;
import com.els.base.inquiry.service.TemplateConfService;
import com.els.base.inquiry.service.TplMouldDetailService;
import com.els.base.inquiry.service.TplOrderItemDetailService;
import com.els.base.material.service.MaterialService;
import com.els.base.utils.uuid.UUIDGenerator;
import com.els.base.workflow.common.service.WorkFlowService;

@Component
public class InquiryCommandInvoker {
	
	private static final Logger logger = LoggerFactory.getLogger(InquiryCommandInvoker.class);
	
	@Transactional
	public <Result> Result invoke(AbstractInquiryCommand<Result> cmd){
		String key = UUIDGenerator.generateUUID();
		long t1 = System.currentTimeMillis();
		logger.debug("开始执行命令[{}] key[{}]", cmd.getClass(), key);
		cmd.setInvoker(this);
		Result result = cmd.execute(this);
		logger.debug("结束执行命令[{}] key[{}],耗时[{}]", cmd.getClass(), key, (System.currentTimeMillis() - t1));
		return result;
	}
	
	@Resource
	private PurOrderService purOrderService;

    @Resource
    protected TemplateConfService templateConfService;
    
    @Resource
    protected InquirySupplierService inquirySupplierService;
    
    @Resource
    protected InquiryPurFileService inquiryPurFileService;
    
    @Resource
    protected InquirySupOrderService inquirySupOrderService;
    
    @Resource
    private InquirySupFileService inquirySupFileService;
    
    @Resource
    private InquiryBusiConditionService inquiryBusiConditionService;
    
    @Resource
    private InquiryQuoteLadderService inquiryQuoteLadderService;
    
    @Resource
    private GenerateCodeService generateCodeService;
    
    @Resource
    private PropertyDefService propertyDefService;
    
    @Resource
    private PropertyValueService propertyValueService;

    @Resource
	private InquiryWaitMaterialService inquiryWaitMaterialService;

    @Resource
	private CompanyUserRefService companyUserRefService;
    
    @Resource
    private MouldDetailService mouldDetailService;
    
    @Resource
    private TplMouldDetailService tplMouLdDetailService;
    
    @Resource
    private TplOrderItemDetailService tplOrderItemDetailService; 
    
    @Resource
    private WorkFlowService workFlowService;
    
    @Resource
    private SystemPriceService systemPriceService;
    
    @Resource
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    
    @Resource
    private MaterialService materialService;
    
    @Resource
    private InformationRecordService informationRecordService;
    
    @Resource
    private MaterielParityService materielParityService;
    
	public TemplateConfService getTemplateConfService() {
		return templateConfService;
	}

	public PurOrderService getPurOrderService() {
		return purOrderService;
	}
	
	public InquirySupplierService getInquirySupplierService() {
		return inquirySupplierService;
	}
	
	public InquiryPurFileService getInquiryPurFileService() {
		return inquiryPurFileService;
	}
	
	public InquirySupOrderService getInquirySupOrderService() {
		return inquirySupOrderService;
	}
	
	public InquirySupFileService getInquirySupFileService() {
		return inquirySupFileService;
	}
	
	public InquiryBusiConditionService getInquiryBusiConditionService() {
		return inquiryBusiConditionService;
	}
	
	public InquiryQuoteLadderService getInquiryQuoteLadderService() {
		return inquiryQuoteLadderService;
	}

	public GenerateCodeService getGenerateCodeService() {
		return generateCodeService;
	}

	public PropertyDefService getPropertyDefService() {
		return propertyDefService;
	}

	public PropertyValueService getPropertyValueService() {
		return propertyValueService;
	}

	public InquiryWaitMaterialService getInquiryWaitMaterialService() {
		return this.inquiryWaitMaterialService;
	}

	public CompanyUserRefService getCompanyUserRefService() {
		return this.companyUserRefService;
	}
	
	public MouldDetailService getMouldDetailService(){
		return this.mouldDetailService;
	}
	
	public TplMouldDetailService getTplMouLdDetailService(){
		return this.tplMouLdDetailService;
	}
	
	public TplOrderItemDetailService getTplOrderItemDetailService(){
		return this.tplOrderItemDetailService;
	}

	public WorkFlowService getWorkFlowService() {
		return workFlowService;
	}

	public SystemPriceService getSystemPriceService() {
		return systemPriceService;
	}

	public ThreadPoolTaskExecutor getThreadPoolTaskExecutor(){
		return this.threadPoolTaskExecutor;
	}
	
	public MaterialService getMaterialService(){
		return this.materialService;
	}
	
	public InformationRecordService getInformationRecordService(){
		return this.informationRecordService;
	}

	public MaterielParityService getMaterielParityService() {
		return materielParityService;
	}
}
