package com.els.base.inquiry.command.pur;

import static java.util.stream.Collectors.counting;
import static java.util.stream.Collectors.groupingBy;
import static java.util.stream.Collectors.toList;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.els.base.core.utils.Assert;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.IOrderItem;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.entity.*;
import com.els.base.inquiry.enumclass.InquiryAuditStatus;
import com.els.base.inquiry.enumclass.InquiryOrderStatus;
import com.els.base.inquiry.enumclass.MessageNotify;
import com.els.base.inquiry.enumclass.OperationTypeEnum;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;

/**
 * 采购方-审批通过操作
 * @author hzy
 *
 */
public class ApprovePassCommand extends AbstractInquiryCommand<String> {
	
	private String purOrderId;

	public ApprovePassCommand(String purOrderId) {
		this.purOrderId = purOrderId;
	}

	@Override
	public String execute(InquiryCommandInvoker invoker) {
		//获取业务ID
		Assert.isNotBlank(this.purOrderId, "询价单Id为空");
	    PurOrder purOrder = invoker.getPurOrderService().queryObjById(this.purOrderId);

		//更新供应商询价单头的状态
		this.modifySupOrderStatus(purOrder);
		//更新供应商询价单头的状态
		this.modifPurOrderStatus(purOrder);

//    	SpringContextHolder.getApplicationContext().publishEvent(new InquiryApprovePassEvent(this.purOrderId));

		SyncPriceToSapCmd cmd = new SyncPriceToSapCmd(this.purOrderId);
		cmd.copyProperties(this);
		invoker.invoke(cmd);

		return null;
	}

	private void modifPurOrderStatus(PurOrder purOrder) {
		PurOrder temp = new PurOrder();
		temp.setId(purOrder.getId());
		// 更新询价单头状态为审批通过
		temp.setAuditStatus(InquiryAuditStatus.AUDIT_PASS.getCode());
		// 更新询价单头状态为已完成
		temp.setInquiryOrderStatus(InquiryOrderStatus.FINISHED.getCode());

		invoker.getPurOrderService().modifyObj(temp);

		//TODO 获取采购商编码
		//发送信息采购商
		this.sendMsg(purOrder.getOrderNo(), purOrder.getPurUserId() ,purOrder.getPurCompanyId());
	}


	private void sendMsg(String orderNo,String userId,String companyCode) {
		Map<String, String> data = new HashMap<>();
		data.put("orderNo", orderNo);
		Message<Map<String, String>> msg = Message.init(data).
				setCompanyCode(companyCode).
				setBusinessTypeCode(MessageNotify.INQUIRY_ORDER_APPROVE_PASS.getCode()).
				addReceiverId(userId).
				setMsgLevel(MessageLevelEnum.HIGH);
		MessageSendUtils.sendMessage(msg);
	}


	@SuppressWarnings("unchecked")
	private void modifySupOrderStatus(PurOrder purOrder) {
		// 根据询价单id查询所有行项目
	    TemplateConf templateConf = invoker.getTemplateConfService().queryObjById(purOrder.getTemplateId());
		List<IOrderItem> orderItems = templateConf.getOrderItemService().queryByPurOrderId(purOrder.getId());
		
		InquirySupOrderExample example = new InquirySupOrderExample();
		example.createCriteria().andPurOrderIdEqualTo(purOrder.getId());
		List<InquirySupOrder> supOrderList = invoker.getInquirySupOrderService().queryAllObjByExample(example);
		
		for (InquirySupOrder inquirySupOrder : supOrderList) {
			InquirySupOrder temp = new InquirySupOrder();
			temp.setId(inquirySupOrder.getId());
			temp.setInquiryOrderStatus(this.getStatus(inquirySupOrder, orderItems));
			temp.setAuditStatus(InquiryAuditStatus.AUDIT_PASS.getCode());
			invoker.getInquirySupOrderService().modifyObj(temp);
			//TODO 获取供应商编码
			String supCompanyCode = inquirySupOrder.getSupCompanySrmCode();
			//发送信息供应商
			this.sendMsg(purOrder.getOrderNo(), inquirySupOrder.getSupUserId(),supCompanyCode);
		}
	}

	/**
	 * 根据供应商的询价单行的接受和拒绝状态，获取询价单头的状态
	 * @param supOrder
	 * @param orderItems
	 * @return
	 */
	private Integer getStatus(InquirySupOrder supOrder, List<IOrderItem> orderItems) {
		
		orderItems = orderItems.parallelStream()
			.filter(orderItem-> orderItem.getSupOrderId().equals(supOrder.getId()))
			.filter(orderItem-> OperationTypeEnum.isPricingOperation(orderItem.getOperation()))
			.collect(toList());
		
		Map<Integer, Long> operationAndItemGroup = orderItems.stream()
				.collect(groupingBy(IOrderItem::getOperation, counting()));
		
		Long acceptCount = operationAndItemGroup.get(OperationTypeEnum.ACCEPTED.getCode());
		if (acceptCount == null) {
			acceptCount = 0L;
		}
		
		if (acceptCount == 0L) {
			
			//如果没有已接受的，就是全部拒绝
			return InquiryOrderStatus.REFUSED.getCode();
			
		}else if (acceptCount.intValue() == orderItems.size()) {
			
			//全部是已接受
			return InquiryOrderStatus.ACCEPTED.getCode();
			
		}else{
			//既不是全部已接受，也不是全部拒绝，就是部分拒绝
			return InquiryOrderStatus.ACCEPT_SECTION.getCode();
		}
	}

}
