package com.els.base.inquiry.command.pur;

import com.els.base.core.utils.Assert;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.entity.InquirySupOrder;
import com.els.base.inquiry.entity.InquirySupOrderExample;
import com.els.base.inquiry.entity.PurOrder;
import com.els.base.inquiry.enumclass.InquiryAuditStatus;
import com.els.base.inquiry.enumclass.InquiryOrderStatus;
import com.els.base.inquiry.enumclass.MessageNotify;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ApproveRefuseCommand extends AbstractInquiryCommand<String> {

	private String purOrderId;

	public ApproveRefuseCommand(String purOrderId) {
		this.purOrderId = purOrderId;
	}

	@Override
	public String execute(InquiryCommandInvoker invoker) {
		Assert.isNotBlank(purOrderId, "询价单id不能为空");
		
		PurOrder purOrder = invoker.getPurOrderService().queryObjById(purOrderId);
		Assert.isNotNull(purOrder, "询价单不存在，请刷新重试");
		
		InquirySupOrder temp = new InquirySupOrder();
		temp.setAuditStatus(InquiryAuditStatus.AUDIT_REJECT.getCode());
		
		//状态改为已发布，让采购员可以重新进行接受或拒绝
		if (purOrder.getQuoteEndDate()!=null 
				&& purOrder.getQuoteEndDate().getTime() < System.currentTimeMillis()) {
			
			//如果已经截止，就该为已冻结
			temp.setInquiryOrderStatus(InquiryOrderStatus.FROZEN.getCode());
			
		}else {
			//如果还没有截止，就该为已发布
			temp.setInquiryOrderStatus(InquiryOrderStatus.PUBLISHED.getCode());
		}
		
		InquirySupOrderExample supOrderExample = new InquirySupOrderExample();
		supOrderExample.createCriteria().andPurOrderIdEqualTo(purOrderId);
		this.invoker.getInquirySupOrderService().modifyByExample(temp, supOrderExample);
		
		// 更新询价单头状态为审批驳回
		PurOrder tmpPur = new PurOrder();
		tmpPur.setId(purOrderId);
		tmpPur.setAuditStatus(InquiryAuditStatus.AUDIT_REJECT.getCode());
		this.invoker.getPurOrderService().modifyObj(tmpPur);

		//TODO 获取采购商编码
		//发送信息采购商
		this.sendMsg(purOrder.getOrderNo(), purOrder.getPurUserId() ,purOrder.getPurCompanyId());

		List<InquirySupOrder> supOrderList = invoker.getInquirySupOrderService().queryAllObjByExample(supOrderExample);

		for (InquirySupOrder inquirySupOrder : supOrderList) {
			//TODO 获取供应商编码
			String supCompanyCode = inquirySupOrder.getSupCompanySrmCode();
			//发送信息供应商
			this.sendMsg(purOrder.getOrderNo(), inquirySupOrder.getSupUserId(),supCompanyCode);
		}

		return null;
	}

	private void sendMsg(String orderNo,String userId,String companyCode) {
		Map<String, String> data = new HashMap<>();
		data.put("orderNo", orderNo);
		Message<Map<String, String>> msg = Message.init(data).
				setCompanyCode(companyCode).
				setBusinessTypeCode(MessageNotify.INQUIRY_ORDER_APPROVE_REFUSE.getCode()).
				addReceiverId(userId).
				setMsgLevel(MessageLevelEnum.HIGH);
		MessageSendUtils.sendMessage(msg);
	}

}
