package com.els.base.inquiry.command.pur;

import java.util.Date;
import java.util.List;

import org.activiti.engine.runtime.ProcessInstance;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.IOrderItem;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.entity.InquiryBusiCondition;
import com.els.base.inquiry.entity.InquiryBusiConditionExample;
import com.els.base.inquiry.entity.InquirySupOrder;
import com.els.base.inquiry.entity.InquirySupOrderExample;
import com.els.base.inquiry.entity.OrderItemM001;
import com.els.base.inquiry.entity.OrderItemM001Example;
import com.els.base.inquiry.entity.PurOrder;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.enumclass.InquiryAuditStatus;
import com.els.base.inquiry.enumclass.InquiryOrderStatus;
import com.els.base.inquiry.enumclass.InquiryQuoteStatus;
import com.els.base.inquiry.enumclass.OperationTypeEnum;
import com.els.base.inquiry.event.ApprovePassListener;
import com.els.base.inquiry.service.OrderItemM001Service;
import com.els.base.inquiry.web.vo.ApproveSubmitVo;
import com.els.base.utils.SpringContextHolder;
import com.els.base.workflow.common.entity.ProcessStartVO;

/**
 * 采购方提交审批操作
 * @author wuwenxin
 *
 */
public class ApproveSubmitCommand extends AbstractInquiryCommand<String> {
	
	private PurOrder purOrder;

	private Boolean isOpen=true;
	
	public ApproveSubmitCommand(ApproveSubmitVo vo) {
		this.purOrder = vo.getPurOrder();
	}

	public ApproveSubmitCommand(ApproveSubmitVo vo,Boolean isOpen) {
		this.purOrder = vo.getPurOrder();
	}

	@Override
	public String execute(InquiryCommandInvoker invoker) {
		
		
		// 1、校验询价单行是否符合提交审批操作
		this.vaild(purOrder);
		PricingCommand pricingCommand = new PricingCommand(purOrder);
		pricingCommand.copyProperties(this);
		invoker.invoke(pricingCommand);
		
		logger.info("记录采购方的接受或拒绝操作");
		purOrder.getItemList().stream()
			.filter(item -> OperationTypeEnum.isPricingOperation(item.getOperation()))
			.forEach(item->{
				OrderItemM001 data = (OrderItemM001)item;
				this.validOrderItem(data);
				TemplateConf templateConf = invoker.getTemplateConfService().queryObjById(purOrder.getTemplateId());
				IOrderItem tmpItem;
				try {
					tmpItem = templateConf.getOrderItemClass().newInstance();
					tmpItem.setId(item.getId());
					tmpItem.setOperation(item.getOperation());
					templateConf.getOrderItemService().modifyStatus(tmpItem);
					
				} catch (InstantiationException | IllegalAccessException e) {
					throw new RuntimeException(e);
				}
			});
		
		logger.info("将采购方询价单头状态改成“审批中”状态");
		PurOrder temp = new PurOrder();
		temp.setId(purOrder.getId());
		temp.setAuditStatus(InquiryAuditStatus.AUDITING.getCode());
		invoker.getPurOrderService().modifyObj(temp);
		
		logger.info("将供应商询价单头状态改成“已冻结”状态");
		this.transformSupOrderToFrozen(purOrder);
		
		logger.info("提交询价单审核，开启审批流");
		String displayPage = String.format("inquiryBillManagerPur?id=%s", purOrder.getId());
		ProcessStartVO vo=null;
		ProcessInstance startProcess=null;
		if(isOpen){
			if(StringUtils.isNotBlank(purOrder.getMaterialUsed())){
				vo = ProcessStartVO.newInstance(purOrder.getMaterialUsed().trim(), purOrder.getOrderNo(), purOrder.getId(), displayPage);
			}else {
				vo = ProcessStartVO.newInstance("xjdgl", purOrder.getOrderNo(), purOrder.getId(), displayPage);
			}
			vo.setListenerClass(ApprovePassListener.class);
			startProcess=invoker.getWorkFlowService().startProcess(vo);
		}else {
			vo = ProcessStartVO.newInstance("xjdgl", purOrder.getOrderNo(), purOrder.getId(), displayPage);
			vo.setListenerClass(ApprovePassListener.class);
			startProcess=invoker.getWorkFlowService().startProcess(vo);
		}
		if (startProcess == null) {
			throw new CommonException("启动审批流程失败");
		}
		
		return null;
	}

	private void vaild(PurOrder purOrder) {
		Assert.isNotNull(purOrder, "询价单信息不能为空");
		
		if (!InquiryOrderStatus.PUBLISHED.getCode().equals(purOrder.getInquiryOrderStatus())) {
			throw new CommonException("只有已发布的询价单才能提交审批");
		}
		
		if (InquiryQuoteStatus.UNQUOTED.getCode().equals(purOrder.getQuoteStatus())) {
			throw new CommonException("询价单是未报价，无法提交审批");
		}
		
		long quotedCount = purOrder.getItemList().stream()
			.filter(orderItem->{
				//找出所有已报价或者已重报的询价单行
				return (InquiryQuoteStatus.QUOTED.getCode().equals(orderItem.getQuotationStatus())
						|| InquiryQuoteStatus.REQUOTED.getCode().equals(orderItem.getQuotationStatus()));
			}).count();
		
		if (quotedCount <= 0) {
			throw new CommonException("没有已报价的行项目，无法提交审批");
		}
		/**
		 * 康尼新加判断，如果存在重报价中的记录，则不允许提交审批
		 * 后期修改：添加判断不能超过报价截止时间
		 */
		OrderItemM001Example example = new OrderItemM001Example();
		example.createCriteria().andPurOrderIdEqualTo(purOrder.getId()).andQuotationStatusEqualTo(InquiryQuoteStatus.REQUOTE.getCode());
		List<OrderItemM001> orderItemM001s = SpringContextHolder.getOneBean(OrderItemM001Service.class).queryAllObjByExample(example);
		if (CollectionUtils.isNotEmpty(orderItemM001s) && 
				(purOrder.getQuoteEndDate() != null && new Date().getTime() < purOrder.getQuoteEndDate().getTime())) {
			throw new CommonException(String.format("存在处于重报价中的记录，请等待供应商【%s】报价后再提交审批", orderItemM001s.get(0).getSupCompanyName()));
		}
		/**
		 * end
		 */
		
		List<IOrderItem> orderItems = purOrder.getItemList();
		orderItems.forEach(orderItem -> {
			
			
			// 如果处于已报价或已重报状态下的询价单行，必须执行接受或拒绝操作
			if ((InquiryQuoteStatus.QUOTED.getCode().equals(orderItem.getQuotationStatus())
					|| InquiryQuoteStatus.REQUOTED.getCode().equals(orderItem.getQuotationStatus()))
					&& !OperationTypeEnum.isPricingOperation(orderItem.getOperation())) {
				throw new CommonException(String.format("还没有确定“接受”或“拒绝”操作，无法提交审核，请检查 [%s] 的物料编码 [%s],", orderItem.getSupCompanyName(), orderItem.getMaterialCode()));
			}
			
			if (OperationTypeEnum.ACCEPTED.getCode().equals(orderItem.getOperation())
					&& StringUtils.isBlank(orderItem.getMaterialCode())) {
				//如果是接受的价格，必须要有物料编码
				throw new CommonException(String.format("物料编码为空，无法提交审批。请检查物料编码[%s]", orderItem.getMaterialCode()));
			}
		});
	}

	private void transformSupOrderToFrozen(PurOrder purOrder) {
		InquirySupOrderExample example = new InquirySupOrderExample();
		example.createCriteria().andPurOrderIdEqualTo(purOrder.getId());
		
		InquirySupOrder tmp = new InquirySupOrder();
		tmp.setInquiryOrderStatus(InquiryOrderStatus.FROZEN.getCode());
		tmp.setAuditStatus(InquiryAuditStatus.AUDITING.getCode());
		invoker.getInquirySupOrderService().modifyByExample(tmp, example);
		
	}

	private void validOrderItem(OrderItemM001 data) {
		Assert.isNotBlank(data.getMaterialCode(), "物料编码不能为空");
		Assert.isNotBlank(data.getPurchaseApply(), "采购申请单号不能为空");
		Assert.isNotBlank(data.getProject(), "行项目号不能为空");
		//String materialCode = data.getMaterialCode();
		// 根据物料编码+采购申请+行项目号查询待询价清单，有且只能查询出一条数据
		/*InquiryWaitMaterialExample example = new InquiryWaitMaterialExample();
		example.createCriteria().andMaterialCodeEqualTo(materialCode)
		.andPurchaseApplyEqualTo(data.getPurchaseApply()).andProjectEqualTo(data.getProject());
		
		List<InquiryWaitMaterial> waitMaterials = invoker.getInquiryWaitMaterialService().queryAllObjByExample(example);
		if (waitMaterials == null || waitMaterials.size() != 1) {
			throw new CommonException("根据物料编码查询待询价清单数据失败");
		}*/
		
		InquiryBusiConditionExample example2 = new InquiryBusiConditionExample();
		example2.createCriteria().andSupOrderIdEqualTo(data.getSupOrderId());
		List<InquiryBusiCondition> busiConditions = invoker.getInquiryBusiConditionService().queryAllObjByExample(example2);
		if (busiConditions == null || busiConditions.size() != 1) {
			throw new CommonException(String.format("查询供应商【%s】商务条件数据失败", data.getSupCompanyName()));
		}
		InquiryBusiCondition busiCondition = busiConditions.get(0);
		//数据校验，判断值不能为空
		Assert.isNotBlank(data.getInfoCategory(), "信息类别不能为空");
		Assert.isNotNull(data.getUntaxedUnitPrice(), "不含税单价不能为空");
		Assert.isNotNull(data.getPlanDeliveryDate(), "计划交货时间不能为空");
		Assert.isNotBlank(data.getPurchaseGroup(), "采购组不能为空");
		Assert.isNotNull(data.getPurOrderQuantity(), "标准采购订单数量不能为空");
		Assert.isNotNull(data.getMinOrderQuantity(), "最小订单数量不能为空");
		Assert.isNotBlank(busiCondition.getTaxCode(), "税码不能为空");
		Assert.isNotBlank(busiCondition.getCurrency(), "货币不能为空");
		Assert.isNotNull(data.getPriceUnit(), "价格单位不能为空");
		Assert.isNotNull(data.getValidDateFrom(), "有效期从不能为空");
		Assert.isNotNull(data.getValidDateTo(), "有效期到不能为空");
	}
	
}
