package com.els.base.inquiry.command.pur;

import java.util.List;

import org.apache.commons.collections.CollectionUtils;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.entity.PurOrder;
import com.els.base.inquiry.entity.PurOrderExample;
import com.els.base.inquiry.enumclass.InquiryOrderStatus;

/**
 * 采购方删除操作，只做逻辑删除，不做物理删除
 * @author wuwenxin
 *
 */
public class BatchDeleteCommand extends AbstractInquiryCommand<String> {
	
	private List<String> ids;
	
	public BatchDeleteCommand(List<String> ids) {
		this.ids = ids;
	}

	@Override
	public String execute(InquiryCommandInvoker invoker) {
		// 校验所选的询价单是否符合删除的条件
		this.valid(ids);
		
		for (String id: ids) {
			DeleteCommand deleteCommand = new DeleteCommand(id);
			deleteCommand.copyProperties(this);
			invoker.invoke(deleteCommand);
		}
		
		return null;
	}

	private void valid(List<String> idList) {
		Assert.isNotEmpty(idList, "数据不能为空");
		
		PurOrderExample example = new PurOrderExample();
		PurOrderExample.Criteria criteria = example.createCriteria();
		criteria.andIdIn(idList);
		List<PurOrder> purOrders = this.invoker.getPurOrderService().queryAllObjByExample(example);
		
		// 根据ids批量查询询价单
		if (CollectionUtils.isEmpty(purOrders)) {
			throw new CommonException("询价单不存在，请刷新后重试");
		}

		for (PurOrder purOrder : purOrders) {
			// 只有当询价单为未发布时才能删除
			if (!InquiryOrderStatus.UNPUBLISHED.getCode().equals(purOrder.getInquiryOrderStatus())) {
				throw new CommonException(String.format("只能删除未发布的询价单，请检查询价单[%s]", purOrder.getOrderNo()));
			}
		}
	
	}

}
