package com.els.base.inquiry.command.pur;

import java.util.List;
import java.util.stream.Collectors;

import com.els.base.core.exception.CommonException;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.entity.PurOrder;
import com.els.base.inquiry.entity.PurOrderExample;
import com.els.base.inquiry.enumclass.InquiryOrderStatus;

/**
 * 采购方批量发布询价单
 * @author wuwenxin
 *
 */
public class BatchPublishCommand extends AbstractInquiryCommand<String> {
	
	private List<String> ids;
	
	public BatchPublishCommand(List<String> ids) {
		this.ids = ids;
	}

	@Override
	public String execute(InquiryCommandInvoker invoker) {
	
		PurOrderExample example = new PurOrderExample();
		example.createCriteria().andIdIn(ids);
		List<PurOrder> purOrders = invoker.getPurOrderService().queryAllObjByExample(example);

		for (PurOrder purOrder : purOrders) {
			if (InquiryOrderStatus.UNPUBLISHED.getCode().equals(purOrder.getInquiryOrderStatus())) {
				continue;
			}
			throw new CommonException(String.format("询价单[%s],已经发布，不用重复发布", purOrder.getOrderNo()));
		}
		
		List<PurOrder> completePurOrderList = ids.parallelStream().map(purOrderId->{
			//查询询价单的详情
			ViewDetailCommand command = new ViewDetailCommand(purOrderId);
			command.copyProperties(this);
			return invoker.invoke(command);
			
		}).collect(Collectors.toList());
		
		
		completePurOrderList.forEach(completePurOrder->{
			//发布询价单
			PublishCommand cmd = new PublishCommand(completePurOrder);
			cmd.copyProperties(this);
			invoker.invoke(cmd);
		});
		
		return null;
	}

	/*private List<PurOrder> getPurOrdersByIds(List<String> idList) {
		List<PurOrder> purOrders = null;
		if (CollectionUtils.isNotEmpty(idList)) {
			purOrders = new ArrayList<>();
			// 通过询价单id获取询价单详情
			for (String purOrderId : idList) {
				ViewDetailCommand cmd = new ViewDetailCommand(purOrderId);
				purOrders.add(invoker.invoke(cmd));
			}
		}
		return purOrders;
	}*/

}
