package com.els.base.inquiry.command.pur;

import java.util.List;
import java.util.stream.Collectors;

import com.els.base.core.utils.Constant;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.entity.InquirySupOrder;
import com.els.base.inquiry.entity.InquirySupOrderExample;
import com.els.base.inquiry.entity.InquiryWaitMaterial;
import com.els.base.inquiry.entity.InquiryWaitMaterialExample;
import com.els.base.inquiry.entity.PurOrder;
import com.els.base.inquiry.entity.PurOrderExample;
import com.els.base.inquiry.enumclass.InquiryOrderStatus;

/**
 * 采购方作废操作
 * @author wuwenxin
 *
 */
public class CancelCommand extends AbstractInquiryCommand<String> {
	
	private List<String> ids;
	
	public CancelCommand(List<String> ids) {
		this.ids = ids;
	}

	@Override
	public String execute(InquiryCommandInvoker invoker) {
		logger.info("作废所有询价单");
		invoker.getPurOrderService().cancelAllPurOrders(ids);
		
		logger.info("根据询价单ID作废所有供应商询价单");
		InquirySupOrderExample inquirySupOrderExample = new InquirySupOrderExample();
		inquirySupOrderExample.createCriteria().andPurOrderIdIn(ids);
		
		InquirySupOrder temp = new InquirySupOrder();
		temp.setInquiryOrderStatus(InquiryOrderStatus.INVALID.getCode());
		
		invoker.getInquirySupOrderService().modifyByExample(temp, inquirySupOrderExample);
		
		logger.info("根据询价单号批量恢复待询价物料");
		PurOrderExample purOrderExample = new PurOrderExample();
		purOrderExample.createCriteria().andIdIn(ids);
		List<PurOrder> purOrderList = invoker.getPurOrderService().queryAllObjByExample(purOrderExample);
		
		List<String> purOrderNoList = purOrderList.stream().map(PurOrder::getOrderNo).collect(Collectors.toList());
		
		InquiryWaitMaterialExample example = new InquiryWaitMaterialExample();
		example.createCriteria().andInquiryOrderNoIn(purOrderNoList);
		
		InquiryWaitMaterial tmp = new InquiryWaitMaterial();
		tmp.setIsCreateInquiryOrder(Constant.NO_INT);
		tmp.setInquiryOrderNo("");
		invoker.getInquiryWaitMaterialService().modifyByExample(tmp, example);
		
		return null;
	}
	
}
