package com.els.base.inquiry.command.pur;

import com.els.base.core.utils.Assert;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.entity.InquirySupOrder;
import com.els.base.inquiry.entity.InquirySupOrderExample;
import com.els.base.inquiry.enumclass.InquiryOrderStatus;

/**
 * 把询价单设置为过期
 * @author hzy
 *
 */
public class FrozenOrderCommand extends AbstractInquiryCommand<String>{
	
	private String purOrderId;

	public FrozenOrderCommand(String purOrderId) {
		this.purOrderId = purOrderId;
	}

	@Override
	public String execute(InquiryCommandInvoker invoker) {
		Assert.isNotBlank(purOrderId, "询价单id不能为空");
		
		InquirySupOrderExample example = new InquirySupOrderExample();
		example.createCriteria().andPurOrderIdEqualTo(purOrderId);
		
		InquirySupOrder supOrder = new InquirySupOrder();
		supOrder.setInquiryOrderStatus(InquiryOrderStatus.FROZEN.getCode());
		this.invoker.getInquirySupOrderService().modifyByExample(supOrder, example);
		
		return null;
	}

}
