package com.els.base.inquiry.command.pur;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.ITarget;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.utils.LaddPriceValider;
import com.els.base.inquiry.entity.PurOrder;
import com.els.base.inquiry.enumclass.InquiryOrderStatus;
import org.apache.commons.collections.CollectionUtils;

public class ModifyCommand extends AbstractInquiryCommand<String> {
	
	private PurOrder purOrder;

	public ModifyCommand(PurOrder purOrder) {
		this.purOrder = purOrder;
	}

	@Override
	public String execute(InquiryCommandInvoker invoker) {
		valid();
		
		//1、删除询价单信息
		DeleteCommand deleteCommand = new DeleteCommand(purOrder.getId());
		deleteCommand.copyProperties(deleteCommand);
		invoker.invoke(deleteCommand);
				
		
		//2、重新创建询价单
		CreateCommand createCommand = new CreateCommand(purOrder);
		createCommand.copyProperties(this);
		return invoker.invoke(createCommand);
	}

	private void valid() {
		Assert.isNotBlank(purOrder.getId(), "询价单id不能为空");
		PurOrder temp = this.invoker.getPurOrderService().queryObjById(purOrder.getId());
		if (!InquiryOrderStatus.UNPUBLISHED.getCode().equals(temp.getInquiryOrderStatus())) {
			throw new CommonException("只有未发布的询价单才能被修改");
		}
		for (int i = 0; CollectionUtils.isNotEmpty(purOrder.getTargetList()) && i< purOrder.getTargetList().size(); i++) {
			ITarget target = purOrder.getTargetList().get(i);
			LaddPriceValider.valid(target.getInquiryQuoteLadders());
		}
//		if (!InquiryQuoteStatus.UNQUOTED.getCode().equals(temp.getQuoteStatus())) {
//			throw new CommonException("只有未报价的询价单才可以被修改");
//		}
	}
}
