package com.els.base.inquiry.command.pur;

import java.util.List;

import org.apache.commons.collections.CollectionUtils;

import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.entity.InquiryWaitMaterial;
import com.els.base.inquiry.entity.PurOrder;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.enumclass.InquiryOrderStatus;
import com.els.base.inquiry.enumclass.InquiryQuoteStatus;
import org.apache.commons.lang.StringUtils;

public class PreviewCommand extends AbstractInquiryCommand<PurOrder> {
	
	private static final String ORDER_NO_GENERATE_CODE = "INQUIRY_ORDER_CODE"; 
	private String templateId;
	private List<InquiryWaitMaterial> waitMaterialList;

	//添加物料用途
	private String materialUsesCode;

	public PreviewCommand(String templateId, List<InquiryWaitMaterial> waitMaterialList) {
		Assert.isNotBlank(templateId, "模板配置不能为空");
		this.templateId =templateId;
		this.waitMaterialList = waitMaterialList;
	}

	public PreviewCommand(String templateId, List<InquiryWaitMaterial> waitMaterialList,String materialUsesCode) {
		Assert.isNotBlank(templateId, "模板配置不能为空");
		this.templateId =templateId;
		this.waitMaterialList = waitMaterialList;
		this.materialUsesCode=materialUsesCode;
	}

	@Override
	public PurOrder execute(InquiryCommandInvoker invoker) {
		
		TemplateConf templateConf = invoker.getTemplateConfService().queryObjById(templateId);
		vaild(templateConf);
		
		// 构造询价单头
		PurOrder order = this.generatePurOrder(templateConf);
//		order.setItemPropertyDefList(templateConf.getOrderItemPropertyDefList());
//		order.setTargetPropertyDefList(templateConf.getOrderItemPropertyDefList());
		
		if (CollectionUtils.isEmpty(waitMaterialList)) {
			return order;
		}
		
		PreviewTargeListCommand poiCmd = new PreviewTargeListCommand(templateId, waitMaterialList);
		poiCmd.copyProperties(this);

		order.setTargetList(invoker.invoke(poiCmd));
		return order;
	}

	private void vaild(TemplateConf templateConf) {
		Assert.isNotNull(templateConf, "模板配置不存在");
		
		if (Constant.YES_INT.equals(templateConf.getIsMouldEnable())) {
			Assert.isNotEmpty(templateConf.getMouldPropertyDefList(), "模板配置异常，模具清单的字段配置为空");
		}
		
		if (Constant.YES_INT.equals(templateConf.getIsBusiCondEnable())) {
			Assert.isNotEmpty(templateConf.getBusiConditionPropertyDefList(), "模板配置异常，商务条件的字段配置为空");
		}
		
		//设置订单行的自定义字段
//		Assert.isNotEmpty(templateConf.getOrderItemPropertyDefList(), "模板配置异常，询价单行的字段配置为空");
		
	}

	private PurOrder generatePurOrder(TemplateConf templateConf) {
		PurOrder purOrder = new PurOrder();
		purOrder.setTemplateConf(templateConf);
		purOrder.setTemplateId(templateConf.getId());

		//添加特定用途的生成规则
		String nextCode = this.invoker.getGenerateCodeService().getNextCode(ORDER_NO_GENERATE_CODE);
		if(StringUtils.isNotBlank(materialUsesCode)){
			purOrder.setOrderNo(materialUsesCode+nextCode);
			purOrder.setMaterialUsed(materialUsesCode);
		}else {
			purOrder.setOrderNo(nextCode);
		}

		purOrder.setType(templateConf.getName());	//询价单类型
		purOrder.setTargetName(templateConf.getName());	//询价单类型
		purOrder.setInquiryOrderStatus(InquiryOrderStatus.UNPUBLISHED.getCode());	//询价单状态
		purOrder.setQuoteStatus(InquiryQuoteStatus.UNQUOTED.getCode());	//报价状态
		purOrder.setIsContainSubItem(templateConf.getIsOrderItemDetailEnable());	//是否包含项目明细
		
		if (this.getPurUser() != null) {
			purOrder.setPurUserName(this.getPurUser().getNickName());	//制单人
			purOrder.setPurUserId(this.getPurUser().getId());
		}
		return purOrder;
	}

}
