package com.els.base.inquiry.command.pur;

import java.util.ArrayList;
import java.util.List;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.IMould;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.mould.master.entity.Mould;

public class PreviewMouldListCommand extends AbstractInquiryCommand<List<IMould>> {

	private List<Mould> mouldList;
	private String templateId;

	public PreviewMouldListCommand(String templateId, List<Mould> mouldList) {
		this.templateId = templateId;
		this.mouldList = mouldList;
	}

	@Override
	public List<IMould> execute(InquiryCommandInvoker invoker) {
		Assert.isNotBlank(templateId, "模板id不能为空");
		Assert.isNotEmpty(mouldList, "模板列表不能为空");

		TemplateConf templateConf = invoker.getTemplateConfService().queryObjById(templateId);
		
		List<IMould> targets = new ArrayList<>();
		Class<? extends IMould> clazz = templateConf.getMouldClass();
		for (Mould mould : mouldList) {
			IMould target  = null;
			try {
				target  = clazz.newInstance();
			} catch (InstantiationException | IllegalAccessException e) {
				throw new CommonException(String.format("转成询价单物料出错,不存在类[%s]", templateConf.getTargetClassName()), e);
			}
			target.build(templateId, mould);
			targets.add(target);
		}
			
		return targets;
	}

}
