package com.els.base.inquiry.command.pur;

import java.util.ArrayList;
import java.util.List;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.ITarget;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.entity.InquiryWaitMaterial;
import com.els.base.inquiry.entity.TemplateConf;

public class PreviewTargeListCommand extends AbstractInquiryCommand<List<ITarget>> {
	
	private String templateId;
	private List<InquiryWaitMaterial> waitMaterialList;

	public PreviewTargeListCommand(String templateId, List<InquiryWaitMaterial> waitMaterialList) {
		this.templateId = templateId;
		this.waitMaterialList = waitMaterialList;
	}

	@Override
	public List<ITarget> execute(InquiryCommandInvoker invoker) {
		Assert.isNotBlank(templateId, "模板id不能为空");
		Assert.isNotEmpty(waitMaterialList, "带询价物料不能为空");

		TemplateConf templateConf = invoker.getTemplateConfService().queryObjById(templateId);
		
		List<ITarget> targets = new ArrayList<>();
		Class<?> clazz = templateConf.getTargetClass();
		
		for (InquiryWaitMaterial inquiryWaitMaterial : waitMaterialList) {
			
			ITarget target;
			try {
				target = (ITarget)clazz.newInstance();
			} catch (InstantiationException | IllegalAccessException e) {
				throw new CommonException(String.format("转成询价单物料出错,不存在类[%s]", templateConf.getTargetClassName()), e);
			}
			target.buildFromWaitMaterial(templateId, inquiryWaitMaterial);
			targets.add(target);
		}
			
		return targets;
	}

}
