package com.els.base.inquiry.command.pur;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.SyncPriceService;
import com.els.base.inquiry.entity.OrderItemM001;
import com.els.base.inquiry.entity.PurOrder;
import com.els.base.inquiry.enumclass.OperationTypeEnum;
import com.els.base.utils.SpringContextHolder;

public class SyncPriceToSapCmd extends AbstractInquiryCommand<String> {
	
	private String purOrderId;

	public SyncPriceToSapCmd(String purOrderId) {
		this.purOrderId = purOrderId;
	}

	@Override
	public String execute(InquiryCommandInvoker invoker) {
		// 将接受的价格更新至erp
		PurOrder purOrder = invoker.invoke(new ViewPricingDetailCommand(purOrderId));
		
		Assert.isNotNull(purOrder, "数据不能为空");
		Assert.isNotBlank(purOrder.getId(), "传入的采购商表头ID为空");
		Assert.isNotEmpty(purOrder.getItemList(), "传入的数据为空，反写sap失败");
		
		//循环调用SAP接口，一次只能写入一条数据，一条数据写入成功后将这条数据保存到SRM系统中系统价格表中
		purOrder.getItemList().stream()
		.filter(orderItem -> OperationTypeEnum.ACCEPTED.getCode().equals(orderItem.getOperation()))
		.forEach(orderItem ->{
			OrderItemM001 data = (OrderItemM001) orderItem;
			//调用接口反写到SAP中
			SyncPriceService syncPriceService = SpringContextHolder.getOneBean(SyncPriceService.class);
			if (syncPriceService == null) {
				throw new CommonException("系统还没有启动价格回写到sap的配置");
			}
			//反写到SAP成功后把数据保存到SRM系统价表中
			try {
				syncPriceService.sendData(data);
			} catch (Exception e) {
				logger.error("供应商报价信息反写SAP接口调用异常:", e);
				throw new CommonException("供应商报价信息反写SAP接口调用异常:"+e.getMessage());
			}
		});
		return null;
	}
	
}
