package com.els.base.inquiry.command.pur;

import java.util.List;
import java.util.stream.Collectors;

import org.apache.commons.collections.CollectionUtils;

import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.IMould;
import com.els.base.inquiry.IMouldDetailService;
import com.els.base.inquiry.IOrderItem;
import com.els.base.inquiry.IOrderItemDetailService;
import com.els.base.inquiry.ITarget;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.entity.InquiryBusiCondition;
import com.els.base.inquiry.entity.InquiryBusiConditionExample;
import com.els.base.inquiry.entity.InquiryQuoteLadder;
import com.els.base.inquiry.entity.InquirySupFile;
import com.els.base.inquiry.entity.InquirySupFileExample;
import com.els.base.inquiry.entity.InquirySupOrder;
import com.els.base.inquiry.entity.InquirySupOrderExample;
import com.els.base.inquiry.entity.PurOrder;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.enumclass.InquiryQuoteLadderType;
import com.els.base.inquiry.enumclass.InquiryQuoteStatus;

/**
 * 采购查看曾报价的询价单详情页面
 * @author wuwenxin
 *
 */
public class ViewPricingDetailCommand extends AbstractInquiryCommand<PurOrder>{

	private String purOrderId;
	private TemplateConf templateConf;
	
	public ViewPricingDetailCommand(String purOrderId) {
		Assert.isNotBlank(purOrderId, "询价单ID不能为空");
		this.purOrderId = purOrderId;
	}

	@Override
	public PurOrder execute(InquiryCommandInvoker invoker) {
		// 1、获取询价单头
		PurOrder order = invoker.getPurOrderService().queryObjById(purOrderId);
		templateConf = invoker.getTemplateConfService().queryObjById(order.getTemplateId());
		order.setTemplateConf(templateConf);
		
		// 2、获取询价单物料
		order.setTargetList(this.getTargetList(this.purOrderId));
		
		// 3、获取表单文件
		order.setPurFileList(invoker.getInquiryPurFileService().queryByPurOrderId(purOrderId));
		
		// 4、获取供应商
		order.setInquirySuppliers(invoker.getInquirySupplierService().queryByPurOrderId(purOrderId));
		
		//获取可见的报价单
		List<String> supOrderIdList = this.getAvailabelSupOrderIds(purOrderId);
		
		//5、获取模具清单
		if (Constant.YES_INT.equals(templateConf.getIsMouldEnable())) {
			order.setMouldList(this.getMouldList(purOrderId,supOrderIdList));
		}
		
		//6、获取询价单行
		order.setItemList(this.getItemList(purOrderId));
		
		//7、获取供应商表单文件列表
		order.setSupFileList(this.getSupFilesByPurOrderId(purOrderId, supOrderIdList));
		
		//8、获取供应商上传的商务条件列表
		order.setBusiConditions(this.getBusiConditionsByPupOrderId(purOrderId, supOrderIdList));
		
		return order;
		
	}

	private List<String> getAvailabelSupOrderIds(String purOrderId) {
		InquirySupOrderExample example = new InquirySupOrderExample();
		
		example.createCriteria()
			.andPurOrderIdEqualTo(purOrderId)
			.andQuoteStatusNotEqualTo(InquiryQuoteStatus.UNQUOTED.getCode());
		List<InquirySupOrder> supOrderList = this.invoker.getInquirySupOrderService().queryAllObjByExample(example);
		if (CollectionUtils.isEmpty(supOrderList)) {
			return null;
		}
		return supOrderList.stream().map(InquirySupOrder::getId).collect(Collectors.toList());
	}

	@SuppressWarnings("unchecked")
	private List<ITarget> getTargetList(String purOrderId) {
		List<ITarget> targetList = templateConf.getTargetService().queryByPurOrderId(purOrderId);
		
		targetList.parallelStream()
			.filter(target-> InquiryQuoteLadderType.LADDER_QUOTE.getCode().equals(target.getQuoteType()) )
			.forEach(target ->{
				List<InquiryQuoteLadder> ladderPrice = invoker.getInquiryQuoteLadderService().queryByTargetId(target.getId());
				target.setInquiryQuoteLadders(ladderPrice);
			});;
		
		return targetList;
	}

	@SuppressWarnings("unchecked")
	private List<IOrderItem> getItemList(String purOrderId) {
		//获取供应商询价单行项目
//		List<IOrderItem> itemList = templateConf.getOrderItemService().queryByPurOrderId(purOrderId);
		List<IOrderItem> itemList = templateConf.getOrderItemService().queryPublishedItemByPurOrderId(purOrderId);
		
		if (CollectionUtils.isEmpty(itemList)) {
			return null;
		}
		
		// 4.1 获取询价单行的阶梯报价
		itemList.parallelStream().forEach(item->{
			if (InquiryQuoteLadderType.LADDER_QUOTE.getCode().equals(item.getQuoteType())) {
				item.setInquiryQuoteLadders(invoker.getInquiryQuoteLadderService().queryByOrderItemId(item.getId()));
			}
		});
		
		if (Constant.YES_INT.equals(templateConf.getIsOrderItemDetailEnable())
				&& CollectionUtils.isNotEmpty(itemList)) {
			//物料成本清单
			this.setOrderDetail(itemList);
		}
		
		return itemList;
	}

	@SuppressWarnings("unchecked")
	private List<IMould> getMouldList(String purOrderId, List<String> supOrderIdList) {
		List<IMould> mouldList = templateConf.getMouldService().queryByPurOrderId(purOrderId);
		
		if (CollectionUtils.isEmpty(mouldList) ) {
			return null;
		}
		
		//模具成本分析清单
		if (Constant.YES_INT.equals(templateConf.getIsMouldDetailEnable())
				&& CollectionUtils.isNotEmpty(mouldList)) {
			this.setMouldDetail(mouldList);
		}
		return mouldList;
		
	}

	@SuppressWarnings("rawtypes")
	private void setMouldDetail(List<IMould> mouldList) {
		if (CollectionUtils.isEmpty(mouldList)) {
			return;
		}
		
		mouldList.parallelStream().forEach(mould->{
			IMouldDetailService service = templateConf.getTplMouLdDetail().getMouldDetailService();
			mould.setMouldDetail(service.queryByMouldId(mould.getId()));
		});
	}

	@SuppressWarnings("rawtypes")
	private void setOrderDetail(List<IOrderItem> itemList) {
		if (CollectionUtils.isEmpty(itemList)) {
			return;
		}
		
		itemList.parallelStream().forEach(item->{
			IOrderItemDetailService orderItemService = templateConf.getTplOrderItemDetail().getOrderItemDetailService();
			item.setOrderItemDetail(orderItemService.queryObjByOrderItemId(item.getId()));
		});
	}

	private List<InquiryBusiCondition> getBusiConditionsByPupOrderId(String pupOrderId, List<String> supOrderIdList) {
		InquiryBusiConditionExample example = new InquiryBusiConditionExample();
		example.createCriteria().andPurOrderIdEqualTo(pupOrderId);
		List<InquiryBusiCondition> busiList = invoker.getInquiryBusiConditionService().queryAllObjByExample(example);
		
//		if (CollectionUtils.isEmpty(busiList)
//				|| CollectionUtils.isEmpty(supOrderIdList)) {
//			return null;
//		}
		
//		return busiList.stream()
//				.filter(busi-> supOrderIdList.contains(busi.getSupOrderId()))
//				.collect(Collectors.toList());
		return busiList;
	}

	// 根据询价单id查询所有供应商表单文件
	private List<InquirySupFile> getSupFilesByPurOrderId(String purOrderId, List<String> supOrderIdList) {
		
		InquirySupFileExample example = new InquirySupFileExample();
		example.createCriteria().andPurOrderIdEqualTo(purOrderId);
		List<InquirySupFile> fileList = invoker.getInquirySupFileService().queryAllObjByExample(example);
		
		if (CollectionUtils.isEmpty(fileList)
				|| CollectionUtils.isEmpty(supOrderIdList)) {
			return null;
		}
		
		return fileList.stream()
				.filter(file-> supOrderIdList.contains(file.getSupOrderId()))
				.collect(Collectors.toList());
	}

}
