package com.els.base.inquiry.command.strategy;

import java.math.BigDecimal;
import java.util.Comparator;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;

import com.els.base.inquiry.ICalculateStrategy;
import com.els.base.inquiry.entity.InquiryQuoteLadder;

/**
 * 阶梯价格计算策略
 * @author hzy
 *
 */
public class LadderPriceStrategy implements ICalculateStrategy {
	
	private static final long serialVersionUID = -6311457356268578875L;
	
	List<InquiryQuoteLadder> inquiryQuoteLadderList;

	public LadderPriceStrategy(List<InquiryQuoteLadder> inquiryQuoteLadderList) {
		super();
		this.inquiryQuoteLadderList = inquiryQuoteLadderList;
	}

	@Override
	public BigDecimal calculate() {
		if (CollectionUtils.isEmpty(inquiryQuoteLadderList)) {
			return BigDecimal.ZERO;
		}
		
		this.inquiryQuoteLadderList.sort(Comparator.comparing(InquiryQuoteLadder::getUntaxedUnitPrice));
		return inquiryQuoteLadderList.get(0).getUntaxedUnitPrice();
	}

}
