package com.els.base.inquiry.command.sup;

import java.util.List;
import java.util.stream.Collectors;

import com.els.base.core.utils.Assert;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.entity.InquirySupOrder;

/**
 * 供应商批量发布报价单
 * @author wuwenxin
 *
 */
public class BatchPublishQuoteCommand extends AbstractInquiryCommand<String> {
	
	private List<String> ids;
	
	public BatchPublishQuoteCommand(List<String> ids) {
		this.ids = ids;
	}

	@Override
	public String execute(InquiryCommandInvoker invoker) {
		Assert.isNotEmpty(ids, "选择的数据不能为空");
		List<InquirySupOrder> supOrders =  this.ids.parallelStream()
			.map(this::getSupOrdersById)
			.collect(Collectors.toList());
		
		Assert.isNotEmpty(supOrders, "数据不存在，请刷新后重试");
		
		// 循环调用发布命令，实现批量发布
		for (InquirySupOrder order : supOrders) {
			PublishQuoteCommand cmd = new PublishQuoteCommand(order);
			cmd.copyProperties(this);
			invoker.invoke(cmd);
		}
		
		return null;
	}

	private InquirySupOrder getSupOrdersById(String supOrderId) {
		SupViewDetailCommand cmd = new SupViewDetailCommand(supOrderId);
		cmd.copyProperties(this);
		return invoker.invoke(cmd);
	}

}
