package com.els.base.inquiry.command.sup;

import java.util.List;

import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.IMouldDetailService;
import com.els.base.inquiry.IOrderItemDetailService;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.entity.InquiryBusiCondition;
import com.els.base.inquiry.entity.InquiryBusiConditionExample;
import com.els.base.inquiry.entity.InquirySupFile;
import com.els.base.inquiry.entity.InquirySupFileExample;
import com.els.base.inquiry.entity.InquirySupOrder;
import com.els.base.inquiry.entity.TemplateConf;

public class SupViewDetailCommand extends AbstractInquiryCommand<InquirySupOrder>{

	private String supOrderId;
//	private TemplateConf templateConf;
	
	public SupViewDetailCommand(String supOrderId) {
		Assert.isNotBlank(supOrderId, "供应商询价单ID不能为空");
		this.supOrderId = supOrderId;
	}

	@SuppressWarnings({ "rawtypes", "unchecked" })
	@Override
	public InquirySupOrder execute(InquiryCommandInvoker invoker) {
		
		// 1、获取供应商询价单头
		InquirySupOrder supOrder = invoker.getInquirySupOrderService().queryObjById(supOrderId);
		
		TemplateConf templateConf = invoker.getTemplateConfService().queryObjById(supOrder.getTemplateId());
		supOrder.setTemplateConf(templateConf);
		
		// 2、获取采购方表单文件
		supOrder.setPurFileList(invoker.getInquiryPurFileService().queryByPurOrderId(supOrder.getPurOrderId()));
		
		// 3、获取供应商表单文件
		supOrder.setSupFileList(this.querySupFilesBySupOrderId(supOrder.getId()));
		
		// 4、获取商务条件
		supOrder.setBusiConditions(this.queryBusiConditionsBySupOrderId(supOrder.getId()));
		
		// 5、获取询价单行的信息
		supOrder.setItemList(templateConf.getOrderItemService().queryBySupOrderId(supOrderId));
		
		supOrder.getItemList().parallelStream().forEach(item->{
			// 5.1 获取询价单行的阶梯报价
			item.setInquiryQuoteLadders(invoker.getInquiryQuoteLadderService().queryByOrderItemId(item.getId()));
			
			
			// 5.2 获取询报价单行的物料成本清单
			if (Constant.YES_INT.equals(templateConf.getIsOrderItemDetailEnable())) {
				IOrderItemDetailService service = templateConf.getTplOrderItemDetail().getOrderItemDetailService();
				item.setOrderItemDetail(service.queryObjByOrderItemId(item.getId()));
			}
		});
		
		
		// 6、获取模具清单的信息
		if (Constant.YES_INT.equals(templateConf.getIsMouldEnable())) {
			supOrder.setMouldList(templateConf.getMouldService().queryBySupOrderId(supOrder.getId()));
			
			if (Constant.YES_INT.equals(templateConf.getIsMouldDetailEnable())) {
				supOrder.getMouldList().parallelStream().forEach(item->{
					IMouldDetailService service = templateConf.getTplMouLdDetail().getMouldDetailService();
					item.setMouldDetail(service.queryByMouldId(item.getId()));
				});
			}
		}
		
		return supOrder;
		
	}

	private List<InquiryBusiCondition> queryBusiConditionsBySupOrderId(String orderId) {
		InquiryBusiConditionExample example = new InquiryBusiConditionExample();
		example.createCriteria().andSupOrderIdEqualTo(orderId);
		List<InquiryBusiCondition> inquiryBusiConditions = invoker.getInquiryBusiConditionService().queryAllObjByExample(example);
		if (inquiryBusiConditions == null || inquiryBusiConditions.size() != 1) {
			inquiryBusiConditions = null;
		}
		return inquiryBusiConditions;
	}

	private List<InquirySupFile> querySupFilesBySupOrderId(String orderId) {
		InquirySupFileExample example = new InquirySupFileExample();
		example.createCriteria().andSupOrderIdEqualTo(orderId);
		return invoker.getInquirySupFileService().queryAllObjByExample(example);
	}

}
