package com.els.base.inquiry.command.template;

import java.util.Date;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.entity.PropertyDef;
import com.els.base.inquiry.entity.TplMouldDetail;
import com.els.base.inquiry.entity.TplMouldDetailExample;
import com.els.base.inquiry.enumclass.PropertyDefTplType;
import com.els.base.inquiry.utils.InquiryConstant;
import com.els.base.inquiry.utils.PropertyDefUtils;

/**
 * 创建模具成本清单的模板
 * @author hzy
 *
 */
public class CreateMouldDetailTplCmd extends AbstractInquiryCommand<String> {

	private TplMouldDetail tplMouLdDetail;

	public CreateMouldDetailTplCmd(TplMouldDetail tplMouLdDetail) {
		this.tplMouLdDetail = tplMouLdDetail;
	}

	@Override
	public String execute(InquiryCommandInvoker invoker) {
		this.valid(tplMouLdDetail);
		
		if (StringUtils.isBlank(tplMouLdDetail.getMouldDtlClassName())) {
			tplMouLdDetail.setMouldDtlClassName(InquiryConstant.DEFALUT_MOULD_DETAIL_CLS.getName());
		}
		if (StringUtils.isBlank(tplMouLdDetail.getMouldDtlServiceName())) {
			tplMouLdDetail.setMouldDtlServiceName(InquiryConstant.DEFALUT_MOULD_DETAIL_SERVICE_CLS.getName());
		}
		
		tplMouLdDetail.setIsHis(Constant.NO_INT);
		if (this.getPurUser() !=null ) {
			tplMouLdDetail.setCreateUserId(this.getPurUser().getId());
			tplMouLdDetail.setCreateUserName(this.getPurUser().getNickName());
		}
		
		if (tplMouLdDetail.getCreateTime() == null) {
			tplMouLdDetail.setCreateTime(new Date());
		}
		
		this.invoker.getTplMouLdDetailService().addObj(tplMouLdDetail);
		
		List<PropertyDef> propertyDefList = tplMouLdDetail.getPropertyDefList();
		
		if (CollectionUtils.isEmpty(propertyDefList)) {
			return tplMouLdDetail.getId();
		}
		
		propertyDefList.stream().forEach(propertyDef->{
			propertyDef.setId(null);
			propertyDef.setTplId(tplMouLdDetail.getId());
			propertyDef.setTplType(PropertyDefTplType.MOULD_DETAIL_TYPE.getCode());
		});
		this.getInvoker().getPropertyDefService().addAll(propertyDefList);
		
		return tplMouLdDetail.getId();
	}

	private void valid(TplMouldDetail tplMouLdDetail) {
		Assert.isNotBlank(tplMouLdDetail.getCode(), "模具成本清单编码不能为空");
		Assert.isNotBlank(tplMouLdDetail.getName(), "模具成本清单名称不能为空");
		Assert.isNotEmpty(tplMouLdDetail.getPropertyDefList(), "字段配置不能为空");
		
		if (!tplMouLdDetail.getCode().matches("[\\w_-]+")) {
			throw new CommonException("编码只能使用英文、数字、下划线、横线");
		}
    	
    	if (tplMouLdDetail.getCode().length() > 32) {
    		throw new CommonException("编码最多只支持32个字符");
		}
    	
    	PropertyDefUtils.valid(tplMouLdDetail.getPropertyDefList());
    	
    	TplMouldDetailExample example = new TplMouldDetailExample();
    	example.createCriteria()
    		.andCodeEqualTo(tplMouLdDetail.getCode())
    		.andIsHisEqualTo(Constant.NO_INT);
    	
    	List<TplMouldDetail> list = invoker.getTplMouLdDetailService().queryAllObjByExample(example);
    	if (CollectionUtils.isNotEmpty(list)) {
			throw new CommonException("模板编码已存在，不能重复添加");
		}
    	
    	example.clear();
    	example.createCriteria()
    		.andNameEqualTo(tplMouLdDetail.getName())
    		.andIsHisEqualTo(Constant.NO_INT);
    	
    	list = invoker.getTplMouLdDetailService().queryAllObjByExample(example);
    	if (CollectionUtils.isNotEmpty(list)) {
    		throw new CommonException("模板名称已存在，不能重复添加");
    	}
    	
	}

}
