package com.els.base.inquiry.command.template;

import java.util.Date;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.entity.PropertyDef;
import com.els.base.inquiry.entity.TplOrderItemDetail;
import com.els.base.inquiry.entity.TplOrderItemDetailExample;
import com.els.base.inquiry.enumclass.PropertyDefTplType;
import com.els.base.inquiry.utils.InquiryConstant;
import com.els.base.inquiry.utils.PropertyDefUtils;

public class CreateOrderItemDetailTplCmd extends AbstractInquiryCommand<String> {

	private TplOrderItemDetail tplOrderItemDetail;

	public CreateOrderItemDetailTplCmd(TplOrderItemDetail tplOrderItemDetail) {
		this.tplOrderItemDetail = tplOrderItemDetail;
	}

	@Override
	public String execute(InquiryCommandInvoker invoker) {
		this.valid(this.tplOrderItemDetail);
		
		if (!tplOrderItemDetail.getCode().matches("[\\w_-]+")) {
			throw new CommonException("编码只能使用英文、数字、下划线、横线");
		}
    	
    	if (tplOrderItemDetail.getCode().length() > 32) {
    		throw new CommonException("编码最多只支持32个字符");
		}
		
		if (StringUtils.isBlank(tplOrderItemDetail.getOrderDtlClassName())) {
			tplOrderItemDetail.setOrderDtlClassName(InquiryConstant.DEFALUT_ORDER_TIEM_DETAIL_CLS.getName());
		}
		if (StringUtils.isBlank(tplOrderItemDetail.getOrderDtlServiceName())) {
			tplOrderItemDetail.setOrderDtlServiceName(InquiryConstant.DEFALUT_ORDER_TIEM_DETAIL_SERVICE_CLS.getName());
		}
		
		tplOrderItemDetail.setIsHis(Constant.NO_INT);
		if (this.getPurUser() != null) {
			tplOrderItemDetail.setCreateUserId(this.getPurUser().getId());
			tplOrderItemDetail.setCreateUserName(this.getPurUser().getNickName());
		}
		
		if (tplOrderItemDetail.getCreateTime() == null) {
			tplOrderItemDetail.setCreateTime(new Date());
		}
		
		this.invoker.getTplOrderItemDetailService().addObj(tplOrderItemDetail);
		
		List<PropertyDef> propertyDefList = tplOrderItemDetail.getPropertyDefList();
		
		if (CollectionUtils.isEmpty(propertyDefList)) {
			return tplOrderItemDetail.getId();
		}
		
		propertyDefList.stream().forEach(propertyDef->{
			propertyDef.setId(null);
			propertyDef.setTplId(tplOrderItemDetail.getId());
			propertyDef.setTplType(PropertyDefTplType.ORDER_DETAIL_TYPE.getCode());
		});
		this.getInvoker().getPropertyDefService().addAll(propertyDefList);
		
		return tplOrderItemDetail.getId();
	}

	private void valid(TplOrderItemDetail tplOrderItemDetail) {
		Assert.isNotBlank(tplOrderItemDetail.getCode(), "物料成本清单编码不能为空");
		Assert.isNotBlank(tplOrderItemDetail.getName(), "物料成本清单名称不能为空");
		Assert.isNotEmpty(tplOrderItemDetail.getPropertyDefList(), "字段配置不能为空");
		
		PropertyDefUtils.valid(tplOrderItemDetail.getPropertyDefList());
		
    	TplOrderItemDetailExample example = new TplOrderItemDetailExample();
    	example.createCriteria()
    		.andCodeEqualTo(tplOrderItemDetail.getCode())
    		.andIsHisEqualTo(Constant.NO_INT);
    	
    	List<TplOrderItemDetail> list = this.invoker.getTplOrderItemDetailService().queryAllObjByExample(example);
    	if (CollectionUtils.isNotEmpty(list)) {
			throw new CommonException("该模板编码已存在，不能重复添加");
		}
    	
    	example.clear();
    	example.createCriteria()
    		.andNameEqualTo(tplOrderItemDetail.getName())
    		.andIsHisEqualTo(Constant.NO_INT);
    	
    	list = this.invoker.getTplOrderItemDetailService().queryAllObjByExample(example);
    	if (CollectionUtils.isNotEmpty(list)) {
    		throw new CommonException("该模板名称已存在，不能重复添加");
    	}
    	
	}

}
