package com.els.base.inquiry.command.template;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.entity.PropertyDef;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.entity.TemplateConfExample;
import com.els.base.inquiry.enumclass.PropertyDefTplType;
import com.els.base.inquiry.utils.InquiryConstant;
import com.els.base.inquiry.utils.PropertyDefUtils;

/**
 * 创建询价单模板
 * @author hzy
 *
 */
public class CreateTemplateConfCmd extends AbstractInquiryCommand<String> {

	private TemplateConf templateConf;

	public CreateTemplateConfCmd(TemplateConf templateConf) {
		this.templateConf = templateConf;
	}

	@Override
	public String execute(InquiryCommandInvoker invoker) {
		//1、校验数据是否正确
		valid(templateConf);
		
		//2、补全数据
		complete(templateConf);
		
		invoker.getTemplateConfService().addObj(templateConf);
		List<PropertyDef> propertyDefList = new ArrayList<>();
		
		templateConf.getOrderItemPropertyDefList().forEach(propertyDef->{
			propertyDef.setId(null);
			propertyDef.setTplId(templateConf.getId());
			propertyDef.setTplType(PropertyDefTplType.ORDER_ITEM.getCode());
			propertyDefList.add(propertyDef);
		});
		

		if (Constant.YES_INT.equals(templateConf.getIsMouldEnable())) {
			templateConf.getMouldPropertyDefList().forEach(propertyDef->{
				propertyDef.setId(null);
				propertyDef.setTplId(templateConf.getId());
				propertyDef.setTplType(PropertyDefTplType.MOULD_TYPE.getCode());
				propertyDefList.add(propertyDef);
			});
		}
		
		if (Constant.YES_INT.equals(templateConf.getIsBusiCondEnable())) {
			templateConf.getBusiConditionPropertyDefList().forEach(propertyDef->{
				propertyDef.setId(null);
				propertyDef.setTplId(templateConf.getId());
				propertyDef.setTplType(PropertyDefTplType.BUSI_TYPE.getCode());
				propertyDefList.add(propertyDef);
			});
		}
		
		invoker.getPropertyDefService().addAll(propertyDefList);
		return templateConf.getId();
	}
	
	private void complete(TemplateConf templateConf) {
		
		templateConf.setIsHis(Constant.NO_INT);
		
		if (templateConf.getCreateTime() == null) {
			templateConf.setCreateTime(new Date());
		}
		
		if (this.getPurUser()!=null) {
			templateConf.setCreateUserId(this.getPurUser().getId());
			templateConf.setCreateUserName(this.getPurUser().getNickName());
		}
		
		if (StringUtils.isBlank(templateConf.getItemClassName())) {
			templateConf.setItemClassName(InquiryConstant.DEFALUT_ORDER_TIEM_CLS.getName());
		}
		if (StringUtils.isBlank(templateConf.getItemServiceClassName())) {
			templateConf.setItemServiceClassName(InquiryConstant.DEFALUT_ORDER_TIEM_SERVICE_CLS.getName());
		}
		if (StringUtils.isBlank(templateConf.getMouldClassName())) {
			templateConf.setMouldClassName(InquiryConstant.DEFALUT_MOULD_CLS.getName());
		}
		if (StringUtils.isBlank(templateConf.getMouldServiceClassName())) {
			templateConf.setMouldServiceClassName(InquiryConstant.DEFALUT_MOULD_SERVICE_CLS.getName());
		}
		if (StringUtils.isBlank(templateConf.getBusiCondClassName())) {
			templateConf.setBusiCondClassName(InquiryConstant.DEFALUT_BUSI_CONDITION_CLS.getName());
		}
		if (StringUtils.isBlank(templateConf.getBusiCondServiceClassName())) {
			templateConf.setBusiCondServiceClassName(InquiryConstant.DEFALUT_BUSI_CONDITION_SERVICE_CLS.getName());
		}
		
	}

	private void valid(TemplateConf templateConf){
		Assert.isNotNull(templateConf, "模板数据不能为空");
		Assert.isNotBlank(templateConf.getCode(), "模板编码不能为空");
		Assert.isNotBlank(templateConf.getName(), "模板名称不能为空");
		Assert.isNotBlank(templateConf.getCategoryCode(), "物料分类不能为空");
		Assert.isNotBlank(templateConf.getCategoryName(), "物料分类不能为空");
		Assert.isNotEmpty(templateConf.getOrderItemPropertyDefList(), "物料清单自定义字段不能为空");
		
		if (!templateConf.getCode().matches("[\\w_-]+")) {
			throw new CommonException("模板编码只能使用英文、数字、下划线、横线");
		}
    	
    	if (templateConf.getCode().length() > 32) {
    		throw new CommonException("模板编码最多只支持32个字符");
		}
    	
		if (Constant.YES_INT.equals(templateConf.getIsMouldEnable())) {
			Assert.isNotEmpty(templateConf.getMouldPropertyDefList(), "模具清单自定义字段不能为空");
		}
		
		if (Constant.YES_INT.equals(templateConf.getIsBusiCondEnable())) {
			Assert.isNotEmpty(templateConf.getBusiConditionPropertyDefList(), "商务条件自定义字段不能为空");
		}
		
		if (Constant.YES_INT.equals(templateConf.getIsMouldDetailEnable())) {
			Assert.isNotBlank(templateConf.getMouldItemDtlTplId(), "请选择模具成本清单的模板");
		}
		
		if (Constant.YES_INT.equals(templateConf.getIsOrderItemDetailEnable())) {
			Assert.isNotBlank(templateConf.getOrderItemDtlTplId(), "请选择物料成本清单的模板");
		}
		
		PropertyDefUtils.valid(templateConf.getOrderItemPropertyDefList());
    	if (Constant.YES_INT.equals(templateConf.getIsMouldEnable())) {
    		PropertyDefUtils.valid(templateConf.getMouldPropertyDefList());
		}
    	
    	if (Constant.YES_INT.equals(templateConf.getIsBusiCondEnable())) {
    		PropertyDefUtils.valid(templateConf.getBusiConditionPropertyDefList());
		}
    	
    	TemplateConfExample example = new TemplateConfExample();
    	example.createCriteria()
    		.andCodeEqualTo(templateConf.getCode())
    		.andIsHisEqualTo(Constant.NO_INT);
    	
    	List<TemplateConf> list = invoker.getTemplateConfService().queryAllObjByExample(example);
    	if (CollectionUtils.isNotEmpty(list)) {
			throw new CommonException("该模板编码已存在，不能重复添加");
		}
    	
    	example.clear();
    	example.createCriteria()
    		.andNameEqualTo(templateConf.getName())
    		.andIsHisEqualTo(Constant.NO_INT);
    	
    	list = invoker.getTemplateConfService().queryAllObjByExample(example);
    	if (CollectionUtils.isNotEmpty(list)) {
			throw new CommonException("该模板名称已存在，不能重复添加");
		}
    	
	}
}
