package com.els.base.inquiry.command.template;

import java.util.List;

import org.apache.commons.collections.CollectionUtils;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.entity.TemplateConfExample;
import com.els.base.inquiry.entity.TplMouldDetail;
import com.els.base.inquiry.entity.TplMouldDetailExample;
import com.els.base.inquiry.enumclass.PropertyDefTplType;

public class DeleteMouldDetailTplCmd extends AbstractInquiryCommand<String> {

	private List<String> idList;

	public DeleteMouldDetailTplCmd(List<String> idList) {
		this.idList = idList;
	}

	@Override
	public String execute(InquiryCommandInvoker invoker) {
		Assert.isNotEmpty(idList, "模板数据不能为空");
		
		idList.stream().forEach(tplMouldDetailId->{
			
			boolean isContain = invoker.getPropertyValueService()
				.isContainTpl(tplMouldDetailId, PropertyDefTplType.MOULD_DETAIL_TYPE.getCode());
			
			if (isContain) {
				throw new CommonException("该模板已经生成业务数据，无法删除");
			}
		});
		
		boolean isConfInTemplateConf = idList.parallelStream().flatMap(tplMouldDetailId->{
			TplMouldDetail tplMouldDetail = invoker.getTplMouLdDetailService().queryObjById(tplMouldDetailId);
			
			TplMouldDetailExample example = new TplMouldDetailExample();
			example.createCriteria().andCodeEqualTo(tplMouldDetail.getCode());
			
			List<TplMouldDetail> tplMouldDetailList = invoker.getTplMouLdDetailService().queryAllObjByExample(example);
			return tplMouldDetailList.stream();
			
		}).anyMatch(tplMoulDetail->{
			TemplateConfExample templateConfExample = new TemplateConfExample();
			templateConfExample.createCriteria().andMouldItemDtlTplIdEqualTo(tplMoulDetail.getId());
			List<TemplateConf> tplList = invoker.getTemplateConfService().queryAllObjByExample(templateConfExample);
			return CollectionUtils.isNotEmpty(tplList);
		});
		
		if (isConfInTemplateConf) {
			throw new CommonException("该模板已经在询报价模板中配置，无法删除");
		}
		
		idList.forEach(templateId->{
			//如果该模板没有差生业务数据，删除所有数据重新生成
			invoker.getPropertyDefService().removeAllByTpl(templateId, PropertyDefTplType.MOULD_DETAIL_TYPE.getCode());
			invoker.getTplMouLdDetailService().deleteObjById(templateId);
		});
		
		return null;
	}

}
