package com.els.base.inquiry.command.template;

import java.util.List;

import org.apache.commons.collections.CollectionUtils;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.ResponseCode;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.entity.TemplateConfExample;
import com.els.base.inquiry.entity.TplOrderItemDetail;
import com.els.base.inquiry.entity.TplOrderItemDetailExample;
import com.els.base.inquiry.enumclass.PropertyDefTplType;

public class DeleteOrderItemDetailTplCmd extends AbstractInquiryCommand<String> {

	private List<String> idList;

	public DeleteOrderItemDetailTplCmd(List<String> idList) {
		this.idList = idList;
	}

	@Override
	public String execute(InquiryCommandInvoker invoker) {
		Assert.isNotEmpty(this.idList, "模板数据不能为空");

		idList.stream().forEach(templateConfId -> {
			boolean isContain = invoker.getPropertyValueService()
				.isContainTpl(templateConfId, PropertyDefTplType.ORDER_DETAIL_TYPE.getCode());

			if (isContain) {
				throw new CommonException("该模板已经生成业务数据，无法删除");
			}
		});
		
		boolean isConfInTemplateConf = idList.parallelStream().flatMap(tplOrderItemDetailId->{
			TplOrderItemDetail tplOrderItemDetail = invoker.getTplOrderItemDetailService().queryObjById(tplOrderItemDetailId);
			
			TplOrderItemDetailExample example = new TplOrderItemDetailExample();
			example.createCriteria().andCodeEqualTo(tplOrderItemDetail.getCode());
			
			List<TplOrderItemDetail> tplMouldDetailList = invoker.getTplOrderItemDetailService().queryAllObjByExample(example);
			return tplMouldDetailList.stream();
			
		}).anyMatch(tplOrderItemDetail->{
			
			TemplateConfExample templateConfExample = new TemplateConfExample();
			templateConfExample.createCriteria().andOrderItemDtlTplIdEqualTo(tplOrderItemDetail.getId());
			List<TemplateConf> tplList = invoker.getTemplateConfService().queryAllObjByExample(templateConfExample);
			return CollectionUtils.isNotEmpty(tplList);
			
		});
		
		if (isConfInTemplateConf) {
			throw new CommonException("该模板已经在询报价模板中配置，无法删除");
		}
		
		idList.forEach(templateConfId -> {
			// 如果该模板没有差生业务数据，删除所有数据
			invoker.getPropertyDefService().removeAllByTpl(templateConfId, PropertyDefTplType.ORDER_DETAIL_TYPE.getCode());
			invoker.getTplOrderItemDetailService().deleteObjById(templateConfId);
		});
		
		return ResponseCode.Success.getCode();
	}

}
