package com.els.base.inquiry.command.template;

import java.util.List;
import java.util.stream.Collectors;

import org.apache.commons.collections.CollectionUtils;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.ResponseCode;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.entity.PurOrder;
import com.els.base.inquiry.entity.PurOrderExample;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.entity.TemplateConfExample;
import com.els.base.inquiry.enumclass.PropertyDefTplType;

public class DeleteTemplateConfCmd extends AbstractInquiryCommand<String> {
	
	private List<String> idList;

	public DeleteTemplateConfCmd(List<String> idList) {
		this.idList = idList;
	}

	@Override
	public String execute(InquiryCommandInvoker invoker) {
		Assert.isNotEmpty(this.idList, "模板数据不能为空");
		
		idList.stream().forEach(templateConfId->{
			boolean isContain = invoker.getPropertyValueService().isContainTpl(templateConfId, PropertyDefTplType.ORDER_ITEM.getCode())
				||invoker.getPropertyValueService().isContainTpl(templateConfId, PropertyDefTplType.BUSI_TYPE.getCode())
				|| invoker.getPropertyValueService().isContainTpl(templateConfId, PropertyDefTplType.MOULD_TYPE.getCode());
			
			if (isContain) {
				throw new CommonException("该模板已经生成业务数据，无法删除");
			}
		});
		
		idList.stream().forEach(templateConfId->{
			TemplateConf temp = invoker.getTemplateConfService().queryObjById(templateConfId);
			if (temp == null) {
				return;
			}
			
			TemplateConfExample templateConfExample = new TemplateConfExample();
			templateConfExample.createCriteria().andCodeEqualTo(temp.getCode());
			
			List<TemplateConf> list = invoker.getTemplateConfService().queryAllObjByExample(templateConfExample);
			List<String> tempIdList = list.stream().map(TemplateConf::getId).collect(Collectors.toList());
			
			PurOrderExample example = new PurOrderExample();
			example.createCriteria().andTemplateIdIn(tempIdList);
			List<PurOrder> poList = invoker.getPurOrderService().queryAllObjByExample(example);
			if (CollectionUtils.isNotEmpty(poList)) {
				throw new CommonException("该模板已经在询报价单上配置，无法删除。");
			}
		});
		
		idList.forEach(templateConfId->{
			// 如果该模板没有差生业务数据，删除所有数据
			invoker.getPropertyDefService().removeAllByTpl(templateConfId, PropertyDefTplType.ORDER_ITEM.getCode());
			invoker.getPropertyDefService().removeAllByTpl(templateConfId, PropertyDefTplType.BUSI_TYPE.getCode());
			invoker.getPropertyDefService().removeAllByTpl(templateConfId, PropertyDefTplType.MOULD_TYPE.getCode());
			invoker.getTemplateConfService().deleteObjById(templateConfId);
		});
		
		return ResponseCode.Success.getCode();
	}

}
