package com.els.base.inquiry.command.template;

import java.util.List;

import org.apache.commons.collections.CollectionUtils;

import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.entity.PurOrder;
import com.els.base.inquiry.entity.PurOrderExample;
import com.els.base.inquiry.enumclass.PropertyDefTplType;

public class IsTemplateConfInUsedCmd extends AbstractInquiryCommand<Boolean> {

	private String templateConfId;

	public IsTemplateConfInUsedCmd(String id) {
		this.templateConfId = id;
	}

	@Override
	public Boolean execute(InquiryCommandInvoker invoker) {
		PurOrderExample example = new PurOrderExample();
		example.createCriteria().andTemplateIdEqualTo(templateConfId);
		List<PurOrder> list = invoker.getPurOrderService().queryAllObjByExample(example);
		
		if (CollectionUtils.isNotEmpty(list)) {
			return true;
		}
		
		if (invoker.getPropertyValueService().isContainTpl(templateConfId, PropertyDefTplType.ORDER_ITEM.getCode())) {
			return true;
		}
		
		return false;
	}

}
