package com.els.base.inquiry.command.template;

import java.util.List;

import org.apache.commons.collections.CollectionUtils;

import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.entity.TemplateConfExample;
import com.els.base.inquiry.entity.TplMouldDetail;
import com.els.base.inquiry.enumclass.PropertyDefTplType;

/**
 * 修改模具成本清单的模板
 * @author hzy
 *
 */
public class ModifyMouldDetailTplCmd extends AbstractInquiryCommand<String> {

	private TplMouldDetail tplMouLdDetail;

	public ModifyMouldDetailTplCmd(TplMouldDetail tplMouLdDetail) {
		this.tplMouLdDetail = tplMouLdDetail;
	}

	@Override
	public String execute(InquiryCommandInvoker invoker) {
		Assert.isNotBlank(tplMouLdDetail.getId(), "模板Id不能为空");
		
		if (!this.isDeleteable(tplMouLdDetail)) {
			//如果已经产生业务数据，就把以前的就模板放到历史表里面，并重新生成
			invoker.getPropertyDefService().moveAllToHisByTpl(tplMouLdDetail.getId(), PropertyDefTplType.MOULD_DETAIL_TYPE.getCode());
			TplMouldDetail tmp = new TplMouldDetail();
			tmp.setId(tplMouLdDetail.getId());
			tmp.setIsHis(Constant.YES_INT);
			invoker.getTplMouLdDetailService().modifyObj(tmp);
			tplMouLdDetail.setId(null);
			
			//创建模板,ID重设
			CreateMouldDetailTplCmd cmd = new CreateMouldDetailTplCmd(tplMouLdDetail);
			cmd.copyProperties(this);
			invoker.invoke(cmd);
			
			List<TemplateConf> templateConfList = this.queryTemplateConf(tmp.getId());
			if (CollectionUtils.isEmpty(templateConfList)) {
				return null;
			}
			for (TemplateConf templateConf : templateConfList) {
				if (Constant.YES_INT.equals(templateConf.getIsHis())) {
					continue;
				}
				
				templateConf = invoker.getTemplateConfService().queryObjById(templateConf.getId());
				templateConf.setMouldItemDtlTplId(tplMouLdDetail.getId());
				templateConf.setTplMouLdDetail(tplMouLdDetail);
				
				ModifyTemplateConfCmd templateConfCmd = new ModifyTemplateConfCmd(templateConf);
				invoker.invoke(templateConfCmd);
			}
			return null;
			
		}else{
			//如果该模板没有差生业务数据，删除所有数据重新生成
			invoker.getPropertyDefService().removeAllByTpl(tplMouLdDetail.getId(), PropertyDefTplType.MOULD_DETAIL_TYPE.getCode());
			invoker.getTplMouLdDetailService().deleteObjById(tplMouLdDetail.getId());
			
			//创建模板,ID重设
			CreateMouldDetailTplCmd cmd = new CreateMouldDetailTplCmd(tplMouLdDetail);
			cmd.copyProperties(this);
			return invoker.invoke(cmd);
		}
		
	}
	
	private List<TemplateConf> queryTemplateConf(String mouldTplId){
		TemplateConfExample example = new TemplateConfExample();
		example.createCriteria().andMouldItemDtlTplIdEqualTo(mouldTplId);
		List<TemplateConf> templateConfList = invoker.getTemplateConfService().queryAllObjByExample(example);
		if (CollectionUtils.isEmpty(templateConfList)) {
			return null;
		}
		
		return templateConfList;
		
	}
	
	private boolean isDeleteable(TplMouldDetail tplMouLdDetail){
		boolean isContain = invoker.getPropertyValueService().isContainTpl(tplMouLdDetail.getId(), PropertyDefTplType.MOULD_DETAIL_TYPE.getCode());
		if (isContain) {
			return false;
		}
		
		List<TemplateConf> templateConfList = this.queryTemplateConf(tplMouLdDetail.getId());
		if (CollectionUtils.isEmpty(templateConfList)) {
			return true;
		}
		
		return templateConfList.stream().noneMatch(template->{
			IsTemplateConfInUsedCmd cmd = new IsTemplateConfInUsedCmd(template.getId());
			return invoker.invoke(cmd);
		});
		
	}

}
