package com.els.base.inquiry.command.template;

import java.util.List;

import org.apache.commons.collections.CollectionUtils;

import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.entity.TemplateConfExample;
import com.els.base.inquiry.entity.TplOrderItemDetail;
import com.els.base.inquiry.enumclass.PropertyDefTplType;

public class ModifyOrderItemDetailTplCmd extends AbstractInquiryCommand<String> {

	private TplOrderItemDetail tplOrderItemDetail;

	public ModifyOrderItemDetailTplCmd(TplOrderItemDetail tplOrderItemDetail) {
		this.tplOrderItemDetail = tplOrderItemDetail;
	}

	@Override
	public String execute(InquiryCommandInvoker invoker) {
		Assert.isNotBlank(tplOrderItemDetail.getId(), "模板Id不能为空");
		
		if (!this.isDeleteable(tplOrderItemDetail.getId())) {
			//如果已经产生业务数据，就把以前的就模板放到历史表里面，并重新生成
			invoker.getPropertyDefService().moveAllToHisByTpl(tplOrderItemDetail.getId(), PropertyDefTplType.ORDER_DETAIL_TYPE.getCode());
			TplOrderItemDetail tmp = new TplOrderItemDetail();
			tmp.setId(tplOrderItemDetail.getId());
			tmp.setIsHis(Constant.YES_INT);
			invoker.getTplOrderItemDetailService().modifyObj(tmp);
			tplOrderItemDetail.setId(null);
			
			//创建模板,ID重设
			CreateOrderItemDetailTplCmd cmd = new CreateOrderItemDetailTplCmd(tplOrderItemDetail);
			cmd.copyProperties(this);
			invoker.invoke(cmd);
			
			List<TemplateConf> templateConfList = this.queryTemplateConf(tmp.getId());
			if (CollectionUtils.isEmpty(templateConfList)) {
				return null;
			}
			for (TemplateConf templateConf : templateConfList) {
				if (Constant.YES_INT.equals(templateConf.getIsHis())) {
					continue;
				}
				
				templateConf = invoker.getTemplateConfService().queryObjById(templateConf.getId());
				templateConf.setTplOrderItemDetail(tplOrderItemDetail);
				templateConf.setOrderItemDtlTplId(tplOrderItemDetail.getId());
				
				ModifyTemplateConfCmd templateConfCmd = new ModifyTemplateConfCmd(templateConf);
				invoker.invoke(templateConfCmd);
			}
			
			return null;
			
		}else{
			//如果该模板没有差生业务数据，删除所有数据重新生成
			invoker.getPropertyDefService().removeAllByTpl(tplOrderItemDetail.getId(), PropertyDefTplType.ORDER_DETAIL_TYPE.getCode());
			invoker.getTplOrderItemDetailService().deleteObjById(tplOrderItemDetail.getId());
			//创建模板,ID重设
			CreateOrderItemDetailTplCmd cmd = new CreateOrderItemDetailTplCmd(tplOrderItemDetail);
			cmd.copyProperties(this);
			return invoker.invoke(cmd);
		}
		
	}
	
	private boolean isDeleteable(String orderItemTplId){
		boolean isContain = invoker.getPropertyValueService().isContainTpl(tplOrderItemDetail.getId(), PropertyDefTplType.ORDER_DETAIL_TYPE.getCode());
		if (isContain) {
			return false;
		}
		
		List<TemplateConf> templateConfList = this.queryTemplateConf(orderItemTplId);
		if (CollectionUtils.isEmpty(templateConfList)) {
			return true;
		}
		
		return templateConfList.stream().noneMatch(template->{
			IsTemplateConfInUsedCmd cmd = new IsTemplateConfInUsedCmd(template.getId());
			return invoker.invoke(cmd);
		});
		
	}

	private List<TemplateConf> queryTemplateConf(String orderItemTplId) {
		TemplateConfExample example = new TemplateConfExample();
		example.createCriteria().andOrderItemDtlTplIdEqualTo(orderItemTplId);
		return invoker.getTemplateConfService().queryAllObjByExample(example);
	}
}
