package com.els.base.inquiry.command.template;

import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.inquiry.AbstractInquiryCommand;
import com.els.base.inquiry.InquiryCommandInvoker;
import com.els.base.inquiry.entity.TemplateConf;
import com.els.base.inquiry.enumclass.PropertyDefTplType;

public class ModifyTemplateConfCmd extends AbstractInquiryCommand<String> {

	private TemplateConf templateConf;

	public ModifyTemplateConfCmd(TemplateConf templateConf) {
		this.templateConf = templateConf;
	}

	@Override
	public String execute(InquiryCommandInvoker invoker) {
		Assert.isNotBlank(templateConf.getId(), "模板Id不能为空");
		
		if (isDeleteAble(templateConf.getId())) {
			//如果该模板没有差生业务数据，删除所有数据重新生成
			invoker.getPropertyDefService().removeAllByTpl(templateConf.getId(), PropertyDefTplType.ORDER_ITEM.getCode());
			invoker.getPropertyDefService().removeAllByTpl(templateConf.getId(), PropertyDefTplType.BUSI_TYPE.getCode());
			invoker.getPropertyDefService().removeAllByTpl(templateConf.getId(), PropertyDefTplType.MOULD_TYPE.getCode());
			invoker.getTemplateConfService().deleteObjById(templateConf.getId());
			
		}else{
			//如果已经产生业务数据，就把以前的就模板放到历史表里面
			invoker.getPropertyDefService().moveAllToHisByTpl(templateConf.getId(), PropertyDefTplType.ORDER_ITEM.getCode());
			invoker.getPropertyDefService().moveAllToHisByTpl(templateConf.getId(), PropertyDefTplType.BUSI_TYPE.getCode());
			invoker.getPropertyDefService().moveAllToHisByTpl(templateConf.getId(), PropertyDefTplType.MOULD_TYPE.getCode());
			
			TemplateConf tmp = new TemplateConf();
			tmp.setId(templateConf.getId());
			tmp.setIsHis(Constant.YES_INT);
			invoker.getTemplateConfService().modifyObj(tmp);
			templateConf.setId(null);
		}
		
		//创建模板,ID重设
		CreateTemplateConfCmd cmd = new CreateTemplateConfCmd(templateConf);
		cmd.copyProperties(this);
		return invoker.invoke(cmd);
	}
	
	
	private boolean isDeleteAble(String id){
		
		IsTemplateConfInUsedCmd cmd = new IsTemplateConfInUsedCmd(id);
		return !invoker.invoke(cmd);
		
	}

}
