package com.els.base.inquiry.entity;

import java.io.Serializable;
import java.util.List;

import com.els.base.inquiry.IMould;
import com.els.base.inquiry.IOrderItem;
import com.els.base.inquiry.ITarget;

import io.swagger.annotations.ApiModelProperty;

public abstract class AbstractInquiryOrder implements Serializable {
	
	private static final long serialVersionUID = 1L;
	
	@ApiModelProperty("询价单-匹配的模板信息")
	private TemplateConf templateConf;

	@ApiModelProperty("询价单-目标名称")
	private String targetName;
	
	@ApiModelProperty("询价单模板id")
	private String templateId;

	@ApiModelProperty("询价单-行信息列表")
	private List<IOrderItem> itemList;
	
	@ApiModelProperty("询价单-模具清单列表")
	private List<IMould> mouldList;

	@ApiModelProperty("询价单-目标信息列表")
	private List<ITarget> targetList;
	
	@ApiModelProperty("询价单-采购方附件列表")
	private List<InquiryPurFile> purFileList;
	
	@ApiModelProperty("询价单-供应商附件列表")
	private List<InquirySupFile> supFileList;
	
	@ApiModelProperty("是否需要物料成本清单")
	private Integer isContainSubItem;
	
	@ApiModelProperty("商务条件列表")
    private List<InquiryBusiCondition> busiConditions;
	
/*
	@ApiModelProperty("询价单行表头信息")
	private List<PropertyDef> itemPropertyDefList;
	
	@ApiModelProperty("询价单物料信息表头信息")
	private List<PropertyDef> targetPropertyDefList;
	
	public List<PropertyDef> getItemPropertyDefList() {
		return itemPropertyDefList;
	}
	
	public void setItemPropertyDefList(List<PropertyDef> itemPropertyDefList) {
		this.itemPropertyDefList = itemPropertyDefList;
	}
	
	public List<PropertyDef> getTargetPropertyDefList() {
		return targetPropertyDefList;
	}
	
	public void setTargetPropertyDefList(List<PropertyDef> targetPropertyDefList) {
		this.targetPropertyDefList = targetPropertyDefList;
	}
*/
    
	public TemplateConf getTemplateConf() {
		return templateConf;
	}
	
	public void setTemplateConf(TemplateConf templateConf) {
		this.templateConf = templateConf;
	}
	
    public List<InquiryBusiCondition> getBusiConditions() {
		return busiConditions;
	}

	public void setBusiConditions(List<InquiryBusiCondition> busiConditions) {
		this.busiConditions = busiConditions;
	}
	
	public String getTemplateId() {
		return templateId;
	}

	public void setTemplateId(String templateId) {
		this.templateId = templateId;
	}

	public List<IOrderItem> getItemList() {
		return itemList;
	}

	public void setItemList(List<IOrderItem> itemList) {
		this.itemList = itemList;
	}

	public List<ITarget> getTargetList() {
		return targetList;
	}

	public void setTargetList(List<ITarget> targetList) {
		this.targetList = targetList;
	}

	public Integer getIsContainSubItem() {
		return isContainSubItem;
	}

	public void setIsContainSubItem(Integer isContainSubItem) {
		this.isContainSubItem = isContainSubItem;
	}

	public String getTargetName() {
		return this.targetName;
	}

	public void setTargetName(String targetName) {
		this.targetName = targetName;
	}

	public List<InquiryPurFile> getPurFileList() {
		return purFileList;
	}

	public void setPurFileList(List<InquiryPurFile> purFileList) {
		this.purFileList = purFileList;
	}

	public List<InquirySupFile> getSupFileList() {
		return supFileList;
	}

	public void setSupFileList(List<InquirySupFile> supFileList) {
		this.supFileList = supFileList;
	}

	public List<IMould> getMouldList() {
		return mouldList;
	}

	public void setMouldList(List<IMould> mouldList) {
		this.mouldList = mouldList;
	}
	
}
