package com.els.base.inquiry.entity;

import java.util.List;

import org.apache.commons.lang.StringUtils;

import com.els.base.core.utils.Assert;
import com.els.base.inquiry.IBusiCondition;
import com.els.base.inquiry.entity.InquiryBusiCondition.InquiryBusiConditionDeserialize;
import com.els.base.inquiry.service.InquirySupOrderService;
import com.els.base.inquiry.service.TemplateConfService;
import com.els.base.inquiry.utils.PropertyDefUtils;
import com.els.base.inquiry.utils.json.ExtendableObjectJsonDeSerialzer;
import com.els.base.inquiry.utils.json.ExtendableObjectJsonSerialzer;
import com.els.base.utils.SpringContextHolder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(value="询报价-询价单-供应商商务条件")
@JsonSerialize(using=ExtendableObjectJsonSerialzer.class)
@JsonDeserialize(using=InquiryBusiConditionDeserialize.class)
public class InquiryBusiCondition implements IBusiCondition {
	
	/*-----------以下代码请勿覆盖--------------*/
	
	public void isVaildForQuote() {
		Assert.isNotBlank(this.getCountry(), "商务条件中，国家不能为空");
//		Assert.isNotBlank(this.getRegion(), "商务条件中，地区不能为空");
	}
	
	private List<PropertyValue> propertyValueList;
	
	@Override
	public List<PropertyValue> getPropertyValueList() {
		return propertyValueList;
	}

	@Override
	public void setPropertyValueList(List<PropertyValue> propertyValueList) {
		this.propertyValueList = propertyValueList;
	}

	@Override
	public List<PropertyDef> getPropertyDefList() {
		if (StringUtils.isNotBlank(this.getTemplateConfId())) {
			TemplateConf templateConf = SpringContextHolder.getOneBean(TemplateConfService.class).queryObjById(this.getTemplateConfId());
			return templateConf.getBusiConditionPropertyDefList();
			
		}else if(StringUtils.isNotBlank(this.getSupOrderId())){
			InquirySupOrder purOrder = SpringContextHolder.getOneBean(InquirySupOrderService.class).queryObjById(this.getSupOrderId());
			if (purOrder!=null && StringUtils.isNotBlank(purOrder.getTemplateId())) {
				TemplateConf templateConf = SpringContextHolder.getOneBean(TemplateConfService.class).queryObjById(purOrder.getTemplateId());
				return templateConf.getBusiConditionPropertyDefList();
			}
		}
		return PropertyDefUtils.getProperyDefByClass(this.getClass());
	}
	
	public static class InquiryBusiConditionDeserialize extends ExtendableObjectJsonDeSerialzer<InquiryBusiCondition>{

		@Override
		public Class<InquiryBusiCondition> getInstanceClass() {
			return InquiryBusiCondition.class;
		}
		
	}
	
	/*-----------以下代码请勿覆盖--------------*/

	
    @ApiModelProperty(hidden=true,value="主键ID")
    private String id;

    @ApiModelProperty(position=3,value="交付方式", dataType="dic_group",notes="delivery_method")
    private String handOverMethod;

    @ApiModelProperty(position=4,value="支付方式", dataType="dic_group",notes="pay_method")
    private String payMethod;

    @ApiModelProperty(position=5,value="交付地点", dataType="dic_group",notes="delivery_address")
    private String handOverAddress;

    @ApiModelProperty(hidden=true,value="供应商询价单头ID")
    private String supOrderId;

    @ApiModelProperty(hidden=true,value="创建者公司id")
    private String supCompanyId;

    @ApiModelProperty("供应商公司名称")
    private String supCompanyName;

    @ApiModelProperty(hidden=true,value="创建者id")
    private String supUserId;

    @ApiModelProperty(hidden=true,value="供应商帐号")
    private String supUserName;

    @ApiModelProperty("供应商SRM编码")
    private String supCompanySrmCode;

    @ApiModelProperty("供应商SAP编码")
    private String supCompanySapCode;

    @ApiModelProperty(position=1,value="国家", dataType="dic_group",notes="country_code")
    private String country;

    @ApiModelProperty(position=2,value="地区(州、省、县)", dataType="dic_group",notes="area_code")
    private String region;
    
    @ApiModelProperty(position=6,value="税码", dataType="dic_group",notes="tax_code")
    private String taxCode;

    @ApiModelProperty(position=7,value="货币", dataType="dic_group",notes="currency_code")
    private String currency;

    @ApiModelProperty(hidden=true,value="模板id")
    private String templateConfId;

    @ApiModelProperty(hidden=true,value="采购方询价单头id")
    private String purOrderId;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getHandOverMethod() {
        return handOverMethod;
    }

    public void setHandOverMethod(String handOverMethod) {
        this.handOverMethod = handOverMethod == null ? null : handOverMethod.trim();
    }

    public String getPayMethod() {
        return payMethod;
    }

    public void setPayMethod(String payMethod) {
        this.payMethod = payMethod == null ? null : payMethod.trim();
    }

    public String getHandOverAddress() {
        return handOverAddress;
    }

    public void setHandOverAddress(String handOverAddress) {
        this.handOverAddress = handOverAddress == null ? null : handOverAddress.trim();
    }

    public String getSupOrderId() {
        return supOrderId;
    }

    public void setSupOrderId(String supOrderId) {
        this.supOrderId = supOrderId == null ? null : supOrderId.trim();
    }

    public String getSupCompanyId() {
        return supCompanyId;
    }

    public void setSupCompanyId(String supCompanyId) {
        this.supCompanyId = supCompanyId == null ? null : supCompanyId.trim();
    }

    public String getSupCompanyName() {
        return supCompanyName;
    }

    public void setSupCompanyName(String supCompanyName) {
        this.supCompanyName = supCompanyName == null ? null : supCompanyName.trim();
    }

    public String getSupUserId() {
        return supUserId;
    }

    public void setSupUserId(String supUserId) {
        this.supUserId = supUserId == null ? null : supUserId.trim();
    }

    public String getSupUserName() {
        return supUserName;
    }

    public void setSupUserName(String supUserName) {
        this.supUserName = supUserName == null ? null : supUserName.trim();
    }

    public String getSupCompanySrmCode() {
        return supCompanySrmCode;
    }

    public void setSupCompanySrmCode(String supCompanySrmCode) {
        this.supCompanySrmCode = supCompanySrmCode == null ? null : supCompanySrmCode.trim();
    }

    public String getSupCompanySapCode() {
        return supCompanySapCode;
    }

    public void setSupCompanySapCode(String supCompanySapCode) {
        this.supCompanySapCode = supCompanySapCode == null ? null : supCompanySapCode.trim();
    }

    public String getCountry() {
        return country;
    }

    public void setCountry(String country) {
        this.country = country == null ? null : country.trim();
    }

    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        this.region = region == null ? null : region.trim();
    }

    public String getTaxCode() {
		return taxCode;
	}

	public void setTaxCode(String taxCode) {
		this.taxCode = taxCode;
	}

	public String getCurrency() {
		return currency;
	}

	public void setCurrency(String currency) {
		this.currency = currency;
	}

	public String getTemplateConfId() {
        return templateConfId;
    }

    public void setTemplateConfId(String templateConfId) {
        this.templateConfId = templateConfId == null ? null : templateConfId.trim();
    }

    public String getPurOrderId() {
        return purOrderId;
    }

    public void setPurOrderId(String purOrderId) {
        this.purOrderId = purOrderId == null ? null : purOrderId.trim();
    }

}