package com.els.base.inquiry.entity;

import com.els.base.core.entity.AbstractExample;
import com.els.base.core.entity.PageView;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class InquiryBusiConditionExample extends AbstractExample<InquiryBusiCondition> implements Serializable {
    protected String orderByClause;

    protected boolean distinct;

    protected List<Criteria> oredCriteria;

    protected PageView<InquiryBusiCondition> pageView = new PageView<InquiryBusiCondition>(1, 10);

    private static final long serialVersionUID = 1L;

    public InquiryBusiConditionExample() {
        oredCriteria = new ArrayList<Criteria>();
    }

    public void setOrderByClause(String orderByClause) {
        this.orderByClause = orderByClause;
    }

    public String getOrderByClause() {
        return orderByClause;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public boolean isDistinct() {
        return distinct;
    }

    public List<Criteria> getOredCriteria() {
        return oredCriteria;
    }

    public void or(Criteria criteria) {
        oredCriteria.add(criteria);
    }

    public Criteria or() {
        Criteria criteria = createCriteriaInternal();
        oredCriteria.add(criteria);
        return criteria;
    }

    public Criteria createCriteria() {
        Criteria criteria = createCriteriaInternal();
        if (oredCriteria.size() == 0) {
            oredCriteria.add(criteria);
        }
        return criteria;
    }

    protected Criteria createCriteriaInternal() {
        Criteria criteria = new Criteria();
        return criteria;
    }

    public void clear() {
        oredCriteria.clear();
        orderByClause = null;
        distinct = false;
    }

    @Override
    public PageView<InquiryBusiCondition> getPageView() {
        return pageView;
    }

    @Override
    public void setPageView(PageView<InquiryBusiCondition> pageView) {
        this.pageView = pageView;
    }

    protected abstract static class GeneratedCriteria implements Serializable {
        protected List<Criterion> criteria;

        private static final long serialVersionUID = 1L;

        protected GeneratedCriteria() {
            super();
            criteria = new ArrayList<Criterion>();
        }

        public boolean isValid() {
            return criteria.size() > 0;
        }

        public List<Criterion> getAllCriteria() {
            return criteria;
        }

        public List<Criterion> getCriteria() {
            return criteria;
        }

        protected void addCriterion(String condition) {
            if (condition == null) {
                throw new RuntimeException("Value for condition cannot be null");
            }
            criteria.add(new Criterion(condition));
        }

        protected void addCriterion(String condition, Object value, String property) {
            if (value == null) {
                throw new RuntimeException("Value for " + property + " cannot be null");
            }
            criteria.add(new Criterion(condition, value));
        }

        protected void addCriterion(String condition, Object value1, Object value2, String property) {
            if (value1 == null || value2 == null) {
                throw new RuntimeException("Between values for " + property + " cannot be null");
            }
            criteria.add(new Criterion(condition, value1, value2));
        }

        public Criteria andIdIsNull() {
            addCriterion("ID is null");
            return (Criteria) this;
        }

        public Criteria andIdIsNotNull() {
            addCriterion("ID is not null");
            return (Criteria) this;
        }

        public Criteria andIdEqualTo(String value) {
            addCriterion("ID =", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotEqualTo(String value) {
            addCriterion("ID <>", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdGreaterThan(String value) {
            addCriterion("ID >", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdGreaterThanOrEqualTo(String value) {
            addCriterion("ID >=", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLessThan(String value) {
            addCriterion("ID <", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLessThanOrEqualTo(String value) {
            addCriterion("ID <=", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLike(String value) {
            addCriterion("ID like", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotLike(String value) {
            addCriterion("ID not like", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdIn(List<String> values) {
            addCriterion("ID in", values, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotIn(List<String> values) {
            addCriterion("ID not in", values, "id");
            return (Criteria) this;
        }

        public Criteria andIdBetween(String value1, String value2) {
            addCriterion("ID between", value1, value2, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotBetween(String value1, String value2) {
            addCriterion("ID not between", value1, value2, "id");
            return (Criteria) this;
        }

        public Criteria andHandOverMethodIsNull() {
            addCriterion("HAND_OVER_METHOD is null");
            return (Criteria) this;
        }

        public Criteria andHandOverMethodIsNotNull() {
            addCriterion("HAND_OVER_METHOD is not null");
            return (Criteria) this;
        }

        public Criteria andHandOverMethodEqualTo(String value) {
            addCriterion("HAND_OVER_METHOD =", value, "handOverMethod");
            return (Criteria) this;
        }

        public Criteria andHandOverMethodNotEqualTo(String value) {
            addCriterion("HAND_OVER_METHOD <>", value, "handOverMethod");
            return (Criteria) this;
        }

        public Criteria andHandOverMethodGreaterThan(String value) {
            addCriterion("HAND_OVER_METHOD >", value, "handOverMethod");
            return (Criteria) this;
        }

        public Criteria andHandOverMethodGreaterThanOrEqualTo(String value) {
            addCriterion("HAND_OVER_METHOD >=", value, "handOverMethod");
            return (Criteria) this;
        }

        public Criteria andHandOverMethodLessThan(String value) {
            addCriterion("HAND_OVER_METHOD <", value, "handOverMethod");
            return (Criteria) this;
        }

        public Criteria andHandOverMethodLessThanOrEqualTo(String value) {
            addCriterion("HAND_OVER_METHOD <=", value, "handOverMethod");
            return (Criteria) this;
        }

        public Criteria andHandOverMethodLike(String value) {
            addCriterion("HAND_OVER_METHOD like", value, "handOverMethod");
            return (Criteria) this;
        }

        public Criteria andHandOverMethodNotLike(String value) {
            addCriterion("HAND_OVER_METHOD not like", value, "handOverMethod");
            return (Criteria) this;
        }

        public Criteria andHandOverMethodIn(List<String> values) {
            addCriterion("HAND_OVER_METHOD in", values, "handOverMethod");
            return (Criteria) this;
        }

        public Criteria andHandOverMethodNotIn(List<String> values) {
            addCriterion("HAND_OVER_METHOD not in", values, "handOverMethod");
            return (Criteria) this;
        }

        public Criteria andHandOverMethodBetween(String value1, String value2) {
            addCriterion("HAND_OVER_METHOD between", value1, value2, "handOverMethod");
            return (Criteria) this;
        }

        public Criteria andHandOverMethodNotBetween(String value1, String value2) {
            addCriterion("HAND_OVER_METHOD not between", value1, value2, "handOverMethod");
            return (Criteria) this;
        }

        public Criteria andPayMethodIsNull() {
            addCriterion("PAY_METHOD is null");
            return (Criteria) this;
        }

        public Criteria andPayMethodIsNotNull() {
            addCriterion("PAY_METHOD is not null");
            return (Criteria) this;
        }

        public Criteria andPayMethodEqualTo(String value) {
            addCriterion("PAY_METHOD =", value, "payMethod");
            return (Criteria) this;
        }

        public Criteria andPayMethodNotEqualTo(String value) {
            addCriterion("PAY_METHOD <>", value, "payMethod");
            return (Criteria) this;
        }

        public Criteria andPayMethodGreaterThan(String value) {
            addCriterion("PAY_METHOD >", value, "payMethod");
            return (Criteria) this;
        }

        public Criteria andPayMethodGreaterThanOrEqualTo(String value) {
            addCriterion("PAY_METHOD >=", value, "payMethod");
            return (Criteria) this;
        }

        public Criteria andPayMethodLessThan(String value) {
            addCriterion("PAY_METHOD <", value, "payMethod");
            return (Criteria) this;
        }

        public Criteria andPayMethodLessThanOrEqualTo(String value) {
            addCriterion("PAY_METHOD <=", value, "payMethod");
            return (Criteria) this;
        }

        public Criteria andPayMethodLike(String value) {
            addCriterion("PAY_METHOD like", value, "payMethod");
            return (Criteria) this;
        }

        public Criteria andPayMethodNotLike(String value) {
            addCriterion("PAY_METHOD not like", value, "payMethod");
            return (Criteria) this;
        }

        public Criteria andPayMethodIn(List<String> values) {
            addCriterion("PAY_METHOD in", values, "payMethod");
            return (Criteria) this;
        }

        public Criteria andPayMethodNotIn(List<String> values) {
            addCriterion("PAY_METHOD not in", values, "payMethod");
            return (Criteria) this;
        }

        public Criteria andPayMethodBetween(String value1, String value2) {
            addCriterion("PAY_METHOD between", value1, value2, "payMethod");
            return (Criteria) this;
        }

        public Criteria andPayMethodNotBetween(String value1, String value2) {
            addCriterion("PAY_METHOD not between", value1, value2, "payMethod");
            return (Criteria) this;
        }

        public Criteria andHandOverAddressIsNull() {
            addCriterion("HAND_OVER_ADDRESS is null");
            return (Criteria) this;
        }

        public Criteria andHandOverAddressIsNotNull() {
            addCriterion("HAND_OVER_ADDRESS is not null");
            return (Criteria) this;
        }

        public Criteria andHandOverAddressEqualTo(String value) {
            addCriterion("HAND_OVER_ADDRESS =", value, "handOverAddress");
            return (Criteria) this;
        }

        public Criteria andHandOverAddressNotEqualTo(String value) {
            addCriterion("HAND_OVER_ADDRESS <>", value, "handOverAddress");
            return (Criteria) this;
        }

        public Criteria andHandOverAddressGreaterThan(String value) {
            addCriterion("HAND_OVER_ADDRESS >", value, "handOverAddress");
            return (Criteria) this;
        }

        public Criteria andHandOverAddressGreaterThanOrEqualTo(String value) {
            addCriterion("HAND_OVER_ADDRESS >=", value, "handOverAddress");
            return (Criteria) this;
        }

        public Criteria andHandOverAddressLessThan(String value) {
            addCriterion("HAND_OVER_ADDRESS <", value, "handOverAddress");
            return (Criteria) this;
        }

        public Criteria andHandOverAddressLessThanOrEqualTo(String value) {
            addCriterion("HAND_OVER_ADDRESS <=", value, "handOverAddress");
            return (Criteria) this;
        }

        public Criteria andHandOverAddressLike(String value) {
            addCriterion("HAND_OVER_ADDRESS like", value, "handOverAddress");
            return (Criteria) this;
        }

        public Criteria andHandOverAddressNotLike(String value) {
            addCriterion("HAND_OVER_ADDRESS not like", value, "handOverAddress");
            return (Criteria) this;
        }

        public Criteria andHandOverAddressIn(List<String> values) {
            addCriterion("HAND_OVER_ADDRESS in", values, "handOverAddress");
            return (Criteria) this;
        }

        public Criteria andHandOverAddressNotIn(List<String> values) {
            addCriterion("HAND_OVER_ADDRESS not in", values, "handOverAddress");
            return (Criteria) this;
        }

        public Criteria andHandOverAddressBetween(String value1, String value2) {
            addCriterion("HAND_OVER_ADDRESS between", value1, value2, "handOverAddress");
            return (Criteria) this;
        }

        public Criteria andHandOverAddressNotBetween(String value1, String value2) {
            addCriterion("HAND_OVER_ADDRESS not between", value1, value2, "handOverAddress");
            return (Criteria) this;
        }

        public Criteria andSupOrderIdIsNull() {
            addCriterion("SUP_ORDER_ID is null");
            return (Criteria) this;
        }

        public Criteria andSupOrderIdIsNotNull() {
            addCriterion("SUP_ORDER_ID is not null");
            return (Criteria) this;
        }

        public Criteria andSupOrderIdEqualTo(String value) {
            addCriterion("SUP_ORDER_ID =", value, "supOrderId");
            return (Criteria) this;
        }

        public Criteria andSupOrderIdNotEqualTo(String value) {
            addCriterion("SUP_ORDER_ID <>", value, "supOrderId");
            return (Criteria) this;
        }

        public Criteria andSupOrderIdGreaterThan(String value) {
            addCriterion("SUP_ORDER_ID >", value, "supOrderId");
            return (Criteria) this;
        }

        public Criteria andSupOrderIdGreaterThanOrEqualTo(String value) {
            addCriterion("SUP_ORDER_ID >=", value, "supOrderId");
            return (Criteria) this;
        }

        public Criteria andSupOrderIdLessThan(String value) {
            addCriterion("SUP_ORDER_ID <", value, "supOrderId");
            return (Criteria) this;
        }

        public Criteria andSupOrderIdLessThanOrEqualTo(String value) {
            addCriterion("SUP_ORDER_ID <=", value, "supOrderId");
            return (Criteria) this;
        }

        public Criteria andSupOrderIdLike(String value) {
            addCriterion("SUP_ORDER_ID like", value, "supOrderId");
            return (Criteria) this;
        }

        public Criteria andSupOrderIdNotLike(String value) {
            addCriterion("SUP_ORDER_ID not like", value, "supOrderId");
            return (Criteria) this;
        }

        public Criteria andSupOrderIdIn(List<String> values) {
            addCriterion("SUP_ORDER_ID in", values, "supOrderId");
            return (Criteria) this;
        }

        public Criteria andSupOrderIdNotIn(List<String> values) {
            addCriterion("SUP_ORDER_ID not in", values, "supOrderId");
            return (Criteria) this;
        }

        public Criteria andSupOrderIdBetween(String value1, String value2) {
            addCriterion("SUP_ORDER_ID between", value1, value2, "supOrderId");
            return (Criteria) this;
        }

        public Criteria andSupOrderIdNotBetween(String value1, String value2) {
            addCriterion("SUP_ORDER_ID not between", value1, value2, "supOrderId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdIsNull() {
            addCriterion("SUP_COMPANY_ID is null");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdIsNotNull() {
            addCriterion("SUP_COMPANY_ID is not null");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdEqualTo(String value) {
            addCriterion("SUP_COMPANY_ID =", value, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdNotEqualTo(String value) {
            addCriterion("SUP_COMPANY_ID <>", value, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdGreaterThan(String value) {
            addCriterion("SUP_COMPANY_ID >", value, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdGreaterThanOrEqualTo(String value) {
            addCriterion("SUP_COMPANY_ID >=", value, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdLessThan(String value) {
            addCriterion("SUP_COMPANY_ID <", value, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdLessThanOrEqualTo(String value) {
            addCriterion("SUP_COMPANY_ID <=", value, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdLike(String value) {
            addCriterion("SUP_COMPANY_ID like", value, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdNotLike(String value) {
            addCriterion("SUP_COMPANY_ID not like", value, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdIn(List<String> values) {
            addCriterion("SUP_COMPANY_ID in", values, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdNotIn(List<String> values) {
            addCriterion("SUP_COMPANY_ID not in", values, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdBetween(String value1, String value2) {
            addCriterion("SUP_COMPANY_ID between", value1, value2, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyIdNotBetween(String value1, String value2) {
            addCriterion("SUP_COMPANY_ID not between", value1, value2, "supCompanyId");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameIsNull() {
            addCriterion("SUP_COMPANY_NAME is null");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameIsNotNull() {
            addCriterion("SUP_COMPANY_NAME is not null");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameEqualTo(String value) {
            addCriterion("SUP_COMPANY_NAME =", value, "supCompanyName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameNotEqualTo(String value) {
            addCriterion("SUP_COMPANY_NAME <>", value, "supCompanyName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameGreaterThan(String value) {
            addCriterion("SUP_COMPANY_NAME >", value, "supCompanyName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameGreaterThanOrEqualTo(String value) {
            addCriterion("SUP_COMPANY_NAME >=", value, "supCompanyName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameLessThan(String value) {
            addCriterion("SUP_COMPANY_NAME <", value, "supCompanyName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameLessThanOrEqualTo(String value) {
            addCriterion("SUP_COMPANY_NAME <=", value, "supCompanyName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameLike(String value) {
            addCriterion("SUP_COMPANY_NAME like", value, "supCompanyName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameNotLike(String value) {
            addCriterion("SUP_COMPANY_NAME not like", value, "supCompanyName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameIn(List<String> values) {
            addCriterion("SUP_COMPANY_NAME in", values, "supCompanyName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameNotIn(List<String> values) {
            addCriterion("SUP_COMPANY_NAME not in", values, "supCompanyName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameBetween(String value1, String value2) {
            addCriterion("SUP_COMPANY_NAME between", value1, value2, "supCompanyName");
            return (Criteria) this;
        }

        public Criteria andSupCompanyNameNotBetween(String value1, String value2) {
            addCriterion("SUP_COMPANY_NAME not between", value1, value2, "supCompanyName");
            return (Criteria) this;
        }

        public Criteria andSupUserIdIsNull() {
            addCriterion("SUP_USER_ID is null");
            return (Criteria) this;
        }

        public Criteria andSupUserIdIsNotNull() {
            addCriterion("SUP_USER_ID is not null");
            return (Criteria) this;
        }

        public Criteria andSupUserIdEqualTo(String value) {
            addCriterion("SUP_USER_ID =", value, "supUserId");
            return (Criteria) this;
        }

        public Criteria andSupUserIdNotEqualTo(String value) {
            addCriterion("SUP_USER_ID <>", value, "supUserId");
            return (Criteria) this;
        }

        public Criteria andSupUserIdGreaterThan(String value) {
            addCriterion("SUP_USER_ID >", value, "supUserId");
            return (Criteria) this;
        }

        public Criteria andSupUserIdGreaterThanOrEqualTo(String value) {
            addCriterion("SUP_USER_ID >=", value, "supUserId");
            return (Criteria) this;
        }

        public Criteria andSupUserIdLessThan(String value) {
            addCriterion("SUP_USER_ID <", value, "supUserId");
            return (Criteria) this;
        }

        public Criteria andSupUserIdLessThanOrEqualTo(String value) {
            addCriterion("SUP_USER_ID <=", value, "supUserId");
            return (Criteria) this;
        }

        public Criteria andSupUserIdLike(String value) {
            addCriterion("SUP_USER_ID like", value, "supUserId");
            return (Criteria) this;
        }

        public Criteria andSupUserIdNotLike(String value) {
            addCriterion("SUP_USER_ID not like", value, "supUserId");
            return (Criteria) this;
        }

        public Criteria andSupUserIdIn(List<String> values) {
            addCriterion("SUP_USER_ID in", values, "supUserId");
            return (Criteria) this;
        }

        public Criteria andSupUserIdNotIn(List<String> values) {
            addCriterion("SUP_USER_ID not in", values, "supUserId");
            return (Criteria) this;
        }

        public Criteria andSupUserIdBetween(String value1, String value2) {
            addCriterion("SUP_USER_ID between", value1, value2, "supUserId");
            return (Criteria) this;
        }

        public Criteria andSupUserIdNotBetween(String value1, String value2) {
            addCriterion("SUP_USER_ID not between", value1, value2, "supUserId");
            return (Criteria) this;
        }

        public Criteria andSupUserNameIsNull() {
            addCriterion("SUP_USER_NAME is null");
            return (Criteria) this;
        }

        public Criteria andSupUserNameIsNotNull() {
            addCriterion("SUP_USER_NAME is not null");
            return (Criteria) this;
        }

        public Criteria andSupUserNameEqualTo(String value) {
            addCriterion("SUP_USER_NAME =", value, "supUserName");
            return (Criteria) this;
        }

        public Criteria andSupUserNameNotEqualTo(String value) {
            addCriterion("SUP_USER_NAME <>", value, "supUserName");
            return (Criteria) this;
        }

        public Criteria andSupUserNameGreaterThan(String value) {
            addCriterion("SUP_USER_NAME >", value, "supUserName");
            return (Criteria) this;
        }

        public Criteria andSupUserNameGreaterThanOrEqualTo(String value) {
            addCriterion("SUP_USER_NAME >=", value, "supUserName");
            return (Criteria) this;
        }

        public Criteria andSupUserNameLessThan(String value) {
            addCriterion("SUP_USER_NAME <", value, "supUserName");
            return (Criteria) this;
        }

        public Criteria andSupUserNameLessThanOrEqualTo(String value) {
            addCriterion("SUP_USER_NAME <=", value, "supUserName");
            return (Criteria) this;
        }

        public Criteria andSupUserNameLike(String value) {
            addCriterion("SUP_USER_NAME like", value, "supUserName");
            return (Criteria) this;
        }

        public Criteria andSupUserNameNotLike(String value) {
            addCriterion("SUP_USER_NAME not like", value, "supUserName");
            return (Criteria) this;
        }

        public Criteria andSupUserNameIn(List<String> values) {
            addCriterion("SUP_USER_NAME in", values, "supUserName");
            return (Criteria) this;
        }

        public Criteria andSupUserNameNotIn(List<String> values) {
            addCriterion("SUP_USER_NAME not in", values, "supUserName");
            return (Criteria) this;
        }

        public Criteria andSupUserNameBetween(String value1, String value2) {
            addCriterion("SUP_USER_NAME between", value1, value2, "supUserName");
            return (Criteria) this;
        }

        public Criteria andSupUserNameNotBetween(String value1, String value2) {
            addCriterion("SUP_USER_NAME not between", value1, value2, "supUserName");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeIsNull() {
            addCriterion("SUP_COMPANY_SRM_CODE is null");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeIsNotNull() {
            addCriterion("SUP_COMPANY_SRM_CODE is not null");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeEqualTo(String value) {
            addCriterion("SUP_COMPANY_SRM_CODE =", value, "supCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeNotEqualTo(String value) {
            addCriterion("SUP_COMPANY_SRM_CODE <>", value, "supCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeGreaterThan(String value) {
            addCriterion("SUP_COMPANY_SRM_CODE >", value, "supCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeGreaterThanOrEqualTo(String value) {
            addCriterion("SUP_COMPANY_SRM_CODE >=", value, "supCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeLessThan(String value) {
            addCriterion("SUP_COMPANY_SRM_CODE <", value, "supCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeLessThanOrEqualTo(String value) {
            addCriterion("SUP_COMPANY_SRM_CODE <=", value, "supCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeLike(String value) {
            addCriterion("SUP_COMPANY_SRM_CODE like", value, "supCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeNotLike(String value) {
            addCriterion("SUP_COMPANY_SRM_CODE not like", value, "supCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeIn(List<String> values) {
            addCriterion("SUP_COMPANY_SRM_CODE in", values, "supCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeNotIn(List<String> values) {
            addCriterion("SUP_COMPANY_SRM_CODE not in", values, "supCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeBetween(String value1, String value2) {
            addCriterion("SUP_COMPANY_SRM_CODE between", value1, value2, "supCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySrmCodeNotBetween(String value1, String value2) {
            addCriterion("SUP_COMPANY_SRM_CODE not between", value1, value2, "supCompanySrmCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySapCodeIsNull() {
            addCriterion("SUP_COMPANY_SAP_CODE is null");
            return (Criteria) this;
        }

        public Criteria andSupCompanySapCodeIsNotNull() {
            addCriterion("SUP_COMPANY_SAP_CODE is not null");
            return (Criteria) this;
        }

        public Criteria andSupCompanySapCodeEqualTo(String value) {
            addCriterion("SUP_COMPANY_SAP_CODE =", value, "supCompanySapCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySapCodeNotEqualTo(String value) {
            addCriterion("SUP_COMPANY_SAP_CODE <>", value, "supCompanySapCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySapCodeGreaterThan(String value) {
            addCriterion("SUP_COMPANY_SAP_CODE >", value, "supCompanySapCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySapCodeGreaterThanOrEqualTo(String value) {
            addCriterion("SUP_COMPANY_SAP_CODE >=", value, "supCompanySapCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySapCodeLessThan(String value) {
            addCriterion("SUP_COMPANY_SAP_CODE <", value, "supCompanySapCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySapCodeLessThanOrEqualTo(String value) {
            addCriterion("SUP_COMPANY_SAP_CODE <=", value, "supCompanySapCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySapCodeLike(String value) {
            addCriterion("SUP_COMPANY_SAP_CODE like", value, "supCompanySapCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySapCodeNotLike(String value) {
            addCriterion("SUP_COMPANY_SAP_CODE not like", value, "supCompanySapCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySapCodeIn(List<String> values) {
            addCriterion("SUP_COMPANY_SAP_CODE in", values, "supCompanySapCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySapCodeNotIn(List<String> values) {
            addCriterion("SUP_COMPANY_SAP_CODE not in", values, "supCompanySapCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySapCodeBetween(String value1, String value2) {
            addCriterion("SUP_COMPANY_SAP_CODE between", value1, value2, "supCompanySapCode");
            return (Criteria) this;
        }

        public Criteria andSupCompanySapCodeNotBetween(String value1, String value2) {
            addCriterion("SUP_COMPANY_SAP_CODE not between", value1, value2, "supCompanySapCode");
            return (Criteria) this;
        }

        public Criteria andCountryIsNull() {
            addCriterion("COUNTRY is null");
            return (Criteria) this;
        }

        public Criteria andCountryIsNotNull() {
            addCriterion("COUNTRY is not null");
            return (Criteria) this;
        }

        public Criteria andCountryEqualTo(String value) {
            addCriterion("COUNTRY =", value, "country");
            return (Criteria) this;
        }

        public Criteria andCountryNotEqualTo(String value) {
            addCriterion("COUNTRY <>", value, "country");
            return (Criteria) this;
        }

        public Criteria andCountryGreaterThan(String value) {
            addCriterion("COUNTRY >", value, "country");
            return (Criteria) this;
        }

        public Criteria andCountryGreaterThanOrEqualTo(String value) {
            addCriterion("COUNTRY >=", value, "country");
            return (Criteria) this;
        }

        public Criteria andCountryLessThan(String value) {
            addCriterion("COUNTRY <", value, "country");
            return (Criteria) this;
        }

        public Criteria andCountryLessThanOrEqualTo(String value) {
            addCriterion("COUNTRY <=", value, "country");
            return (Criteria) this;
        }

        public Criteria andCountryLike(String value) {
            addCriterion("COUNTRY like", value, "country");
            return (Criteria) this;
        }

        public Criteria andCountryNotLike(String value) {
            addCriterion("COUNTRY not like", value, "country");
            return (Criteria) this;
        }

        public Criteria andCountryIn(List<String> values) {
            addCriterion("COUNTRY in", values, "country");
            return (Criteria) this;
        }

        public Criteria andCountryNotIn(List<String> values) {
            addCriterion("COUNTRY not in", values, "country");
            return (Criteria) this;
        }

        public Criteria andCountryBetween(String value1, String value2) {
            addCriterion("COUNTRY between", value1, value2, "country");
            return (Criteria) this;
        }

        public Criteria andCountryNotBetween(String value1, String value2) {
            addCriterion("COUNTRY not between", value1, value2, "country");
            return (Criteria) this;
        }

        public Criteria andRegionIsNull() {
            addCriterion("REGION is null");
            return (Criteria) this;
        }

        public Criteria andRegionIsNotNull() {
            addCriterion("REGION is not null");
            return (Criteria) this;
        }

        public Criteria andRegionEqualTo(String value) {
            addCriterion("REGION =", value, "region");
            return (Criteria) this;
        }

        public Criteria andRegionNotEqualTo(String value) {
            addCriterion("REGION <>", value, "region");
            return (Criteria) this;
        }

        public Criteria andRegionGreaterThan(String value) {
            addCriterion("REGION >", value, "region");
            return (Criteria) this;
        }

        public Criteria andRegionGreaterThanOrEqualTo(String value) {
            addCriterion("REGION >=", value, "region");
            return (Criteria) this;
        }

        public Criteria andRegionLessThan(String value) {
            addCriterion("REGION <", value, "region");
            return (Criteria) this;
        }

        public Criteria andRegionLessThanOrEqualTo(String value) {
            addCriterion("REGION <=", value, "region");
            return (Criteria) this;
        }

        public Criteria andRegionLike(String value) {
            addCriterion("REGION like", value, "region");
            return (Criteria) this;
        }

        public Criteria andRegionNotLike(String value) {
            addCriterion("REGION not like", value, "region");
            return (Criteria) this;
        }

        public Criteria andRegionIn(List<String> values) {
            addCriterion("REGION in", values, "region");
            return (Criteria) this;
        }

        public Criteria andRegionNotIn(List<String> values) {
            addCriterion("REGION not in", values, "region");
            return (Criteria) this;
        }

        public Criteria andRegionBetween(String value1, String value2) {
            addCriterion("REGION between", value1, value2, "region");
            return (Criteria) this;
        }

        public Criteria andRegionNotBetween(String value1, String value2) {
            addCriterion("REGION not between", value1, value2, "region");
            return (Criteria) this;
        }

        public Criteria andTaxCodeIsNull() {
            addCriterion("tax_code is null");
            return (Criteria) this;
        }

        public Criteria andTaxCodeIsNotNull() {
            addCriterion("tax_code is not null");
            return (Criteria) this;
        }

        public Criteria andTaxCodeEqualTo(String value) {
            addCriterion("tax_code =", value, "taxCode");
            return (Criteria) this;
        }

        public Criteria andTaxCodeNotEqualTo(String value) {
            addCriterion("tax_code <>", value, "taxCode");
            return (Criteria) this;
        }

        public Criteria andTaxCodeGreaterThan(String value) {
            addCriterion("tax_code >", value, "taxCode");
            return (Criteria) this;
        }

        public Criteria andTaxCodeGreaterThanOrEqualTo(String value) {
            addCriterion("tax_code >=", value, "taxCode");
            return (Criteria) this;
        }

        public Criteria andTaxCodeLessThan(String value) {
            addCriterion("tax_code <", value, "taxCode");
            return (Criteria) this;
        }

        public Criteria andTaxCodeLessThanOrEqualTo(String value) {
            addCriterion("tax_code <=", value, "taxCode");
            return (Criteria) this;
        }

        public Criteria andTaxCodeLike(String value) {
            addCriterion("tax_code like", value, "taxCode");
            return (Criteria) this;
        }

        public Criteria andTaxCodeNotLike(String value) {
            addCriterion("tax_code not like", value, "taxCode");
            return (Criteria) this;
        }

        public Criteria andTaxCodeIn(List<String> values) {
            addCriterion("tax_code in", values, "taxCode");
            return (Criteria) this;
        }

        public Criteria andTaxCodeNotIn(List<String> values) {
            addCriterion("tax_code not in", values, "taxCode");
            return (Criteria) this;
        }

        public Criteria andTaxCodeBetween(String value1, String value2) {
            addCriterion("tax_code between", value1, value2, "taxCode");
            return (Criteria) this;
        }

        public Criteria andTaxCodeNotBetween(String value1, String value2) {
            addCriterion("tax_code not between", value1, value2, "taxCode");
            return (Criteria) this;
        }

        public Criteria andCurrencyIsNull() {
            addCriterion("currency is null");
            return (Criteria) this;
        }

        public Criteria andCurrencyIsNotNull() {
            addCriterion("currency is not null");
            return (Criteria) this;
        }

        public Criteria andCurrencyEqualTo(String value) {
            addCriterion("currency =", value, "currency");
            return (Criteria) this;
        }

        public Criteria andCurrencyNotEqualTo(String value) {
            addCriterion("currency <>", value, "currency");
            return (Criteria) this;
        }

        public Criteria andCurrencyGreaterThan(String value) {
            addCriterion("currency >", value, "currency");
            return (Criteria) this;
        }

        public Criteria andCurrencyGreaterThanOrEqualTo(String value) {
            addCriterion("currency >=", value, "currency");
            return (Criteria) this;
        }

        public Criteria andCurrencyLessThan(String value) {
            addCriterion("currency <", value, "currency");
            return (Criteria) this;
        }

        public Criteria andCurrencyLessThanOrEqualTo(String value) {
            addCriterion("currency <=", value, "currency");
            return (Criteria) this;
        }

        public Criteria andCurrencyLike(String value) {
            addCriterion("currency like", value, "currency");
            return (Criteria) this;
        }

        public Criteria andCurrencyNotLike(String value) {
            addCriterion("currency not like", value, "currency");
            return (Criteria) this;
        }

        public Criteria andCurrencyIn(List<String> values) {
            addCriterion("currency in", values, "currency");
            return (Criteria) this;
        }

        public Criteria andCurrencyNotIn(List<String> values) {
            addCriterion("currency not in", values, "currency");
            return (Criteria) this;
        }

        public Criteria andCurrencyBetween(String value1, String value2) {
            addCriterion("currency between", value1, value2, "currency");
            return (Criteria) this;
        }

        public Criteria andCurrencyNotBetween(String value1, String value2) {
            addCriterion("currency not between", value1, value2, "currency");
            return (Criteria) this;
        }

        public Criteria andTemplateConfIdIsNull() {
            addCriterion("TEMPLATE_CONF_ID is null");
            return (Criteria) this;
        }

        public Criteria andTemplateConfIdIsNotNull() {
            addCriterion("TEMPLATE_CONF_ID is not null");
            return (Criteria) this;
        }

        public Criteria andTemplateConfIdEqualTo(String value) {
            addCriterion("TEMPLATE_CONF_ID =", value, "templateConfId");
            return (Criteria) this;
        }

        public Criteria andTemplateConfIdNotEqualTo(String value) {
            addCriterion("TEMPLATE_CONF_ID <>", value, "templateConfId");
            return (Criteria) this;
        }

        public Criteria andTemplateConfIdGreaterThan(String value) {
            addCriterion("TEMPLATE_CONF_ID >", value, "templateConfId");
            return (Criteria) this;
        }

        public Criteria andTemplateConfIdGreaterThanOrEqualTo(String value) {
            addCriterion("TEMPLATE_CONF_ID >=", value, "templateConfId");
            return (Criteria) this;
        }

        public Criteria andTemplateConfIdLessThan(String value) {
            addCriterion("TEMPLATE_CONF_ID <", value, "templateConfId");
            return (Criteria) this;
        }

        public Criteria andTemplateConfIdLessThanOrEqualTo(String value) {
            addCriterion("TEMPLATE_CONF_ID <=", value, "templateConfId");
            return (Criteria) this;
        }

        public Criteria andTemplateConfIdLike(String value) {
            addCriterion("TEMPLATE_CONF_ID like", value, "templateConfId");
            return (Criteria) this;
        }

        public Criteria andTemplateConfIdNotLike(String value) {
            addCriterion("TEMPLATE_CONF_ID not like", value, "templateConfId");
            return (Criteria) this;
        }

        public Criteria andTemplateConfIdIn(List<String> values) {
            addCriterion("TEMPLATE_CONF_ID in", values, "templateConfId");
            return (Criteria) this;
        }

        public Criteria andTemplateConfIdNotIn(List<String> values) {
            addCriterion("TEMPLATE_CONF_ID not in", values, "templateConfId");
            return (Criteria) this;
        }

        public Criteria andTemplateConfIdBetween(String value1, String value2) {
            addCriterion("TEMPLATE_CONF_ID between", value1, value2, "templateConfId");
            return (Criteria) this;
        }

        public Criteria andTemplateConfIdNotBetween(String value1, String value2) {
            addCriterion("TEMPLATE_CONF_ID not between", value1, value2, "templateConfId");
            return (Criteria) this;
        }

        public Criteria andPurOrderIdIsNull() {
            addCriterion("PUR_ORDER_ID is null");
            return (Criteria) this;
        }

        public Criteria andPurOrderIdIsNotNull() {
            addCriterion("PUR_ORDER_ID is not null");
            return (Criteria) this;
        }

        public Criteria andPurOrderIdEqualTo(String value) {
            addCriterion("PUR_ORDER_ID =", value, "purOrderId");
            return (Criteria) this;
        }

        public Criteria andPurOrderIdNotEqualTo(String value) {
            addCriterion("PUR_ORDER_ID <>", value, "purOrderId");
            return (Criteria) this;
        }

        public Criteria andPurOrderIdGreaterThan(String value) {
            addCriterion("PUR_ORDER_ID >", value, "purOrderId");
            return (Criteria) this;
        }

        public Criteria andPurOrderIdGreaterThanOrEqualTo(String value) {
            addCriterion("PUR_ORDER_ID >=", value, "purOrderId");
            return (Criteria) this;
        }

        public Criteria andPurOrderIdLessThan(String value) {
            addCriterion("PUR_ORDER_ID <", value, "purOrderId");
            return (Criteria) this;
        }

        public Criteria andPurOrderIdLessThanOrEqualTo(String value) {
            addCriterion("PUR_ORDER_ID <=", value, "purOrderId");
            return (Criteria) this;
        }

        public Criteria andPurOrderIdLike(String value) {
            addCriterion("PUR_ORDER_ID like", value, "purOrderId");
            return (Criteria) this;
        }

        public Criteria andPurOrderIdNotLike(String value) {
            addCriterion("PUR_ORDER_ID not like", value, "purOrderId");
            return (Criteria) this;
        }

        public Criteria andPurOrderIdIn(List<String> values) {
            addCriterion("PUR_ORDER_ID in", values, "purOrderId");
            return (Criteria) this;
        }

        public Criteria andPurOrderIdNotIn(List<String> values) {
            addCriterion("PUR_ORDER_ID not in", values, "purOrderId");
            return (Criteria) this;
        }

        public Criteria andPurOrderIdBetween(String value1, String value2) {
            addCriterion("PUR_ORDER_ID between", value1, value2, "purOrderId");
            return (Criteria) this;
        }

        public Criteria andPurOrderIdNotBetween(String value1, String value2) {
            addCriterion("PUR_ORDER_ID not between", value1, value2, "purOrderId");
            return (Criteria) this;
        }
    }

    public static class Criteria extends GeneratedCriteria implements Serializable {
        private static final long serialVersionUID = 1L;

        protected Criteria() {
            super();
        }
    }

    public static class Criterion implements Serializable {
        private String condition;

        private Object value;

        private Object secondValue;

        private boolean noValue;

        private boolean singleValue;

        private boolean betweenValue;

        private boolean listValue;

        private String typeHandler;

        private static final long serialVersionUID = 1L;

        public String getCondition() {
            return condition;
        }

        public Object getValue() {
            return value;
        }

        public Object getSecondValue() {
            return secondValue;
        }

        public boolean isNoValue() {
            return noValue;
        }

        public boolean isSingleValue() {
            return singleValue;
        }

        public boolean isBetweenValue() {
            return betweenValue;
        }

        public boolean isListValue() {
            return listValue;
        }

        public String getTypeHandler() {
            return typeHandler;
        }

        protected Criterion(String condition) {
            super();
            this.condition = condition;
            this.typeHandler = null;
            this.noValue = true;
        }

        protected Criterion(String condition, Object value, String typeHandler) {
            super();
            this.condition = condition;
            this.value = value;
            this.typeHandler = typeHandler;
            if (value instanceof List<?>) {
                this.listValue = true;
            } else {
                this.singleValue = true;
            }
        }

        protected Criterion(String condition, Object value) {
            this(condition, value, null);
        }

        protected Criterion(String condition, Object value, Object secondValue, String typeHandler) {
            super();
            this.condition = condition;
            this.value = value;
            this.secondValue = secondValue;
            this.typeHandler = typeHandler;
            this.betweenValue = true;
        }

        protected Criterion(String condition, Object value, Object secondValue) {
            this(condition, value, secondValue, null);
        }
    }
}