package com.els.base.inquiry.entity;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import com.els.base.inquiry.IMould;
import com.els.base.inquiry.IMouldDetail;
import com.els.base.inquiry.service.PurOrderService;
import com.els.base.inquiry.service.TemplateConfService;
import com.els.base.inquiry.utils.PropertyDefUtils;
import com.els.base.inquiry.utils.json.ExtendableObjectJsonSerialzer;
import com.els.base.inquiry.utils.json.InquiryMouldJsonDeSerialzer;
import com.els.base.mould.master.entity.Mould;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.uuid.UUIDGenerator;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@JsonSerialize(using=ExtendableObjectJsonSerialzer.class)
@JsonDeserialize(using=InquiryMouldJsonDeSerialzer.class)
@ApiModel(value="询报价-模具清单")
public class InquiryMould implements IMould, Cloneable {
	
	/*-------------请勿覆盖---------------------*/
	
	@Override
	public void build(String templateId, Mould mould) {
		this.setMouldCode(mould.getMouldCode());
		this.setMouldName(mould.getMouldDesc());
		this.setMoldMaterial(mould.getMouldMaterial());
		if (mould.getMouldLifetime() != null) {
			this.setMoldLife(mould.getMouldLifetime().intValue());
		}
//		this.setMouldSpecifications(mould.getMouldModel());
//		this.setOutOfModulus(mould.getMouldConsumedLifetime().intValue());
		this.setWaitMaterialId(mould.getId());
	}
	
	@Override
	public IMould build(PurOrder purOrder, InquirySupOrder supOrder) {
		try {
			InquiryMould newMould = (InquiryMould) this.clone();
			newMould.setId(UUIDGenerator.generateUUID());
			newMould.setPurOrderId(purOrder.getId());
			newMould.setSupOrderId(supOrder.getId());
			newMould.setSupCompanyName(supOrder.getSupCompanyName());
			newMould.setSupCompanySrmCode(supOrder.getSupCompanySrmCode());
			newMould.setSupCompanySapCode(supOrder.getSupCompanySapCode());
			newMould.setTemplateId(purOrder.getTemplateId());
			return newMould;
			
		} catch (CloneNotSupportedException e) {
			throw new RuntimeException(e);
		}
	}
	
	public InquiryMould() {
		super();
	}
	
	@ApiModelProperty(position=9, value="成本分析清单",dataType="button")
	private IMouldDetail mouldDetail;
	
	private List<PropertyValue> propertyValueList;

	@Override
	public IMouldDetail getMouldDetail() {
		return mouldDetail;
	}

	@Override
	public void setMouldDetail(IMouldDetail mouldDetail) {
		this.mouldDetail = mouldDetail;
	}

	@Override
	public List<PropertyValue> getPropertyValueList() {
		return propertyValueList;
	}

	@Override
	public void setPropertyValueList(List<PropertyValue> propertyValueList) {
		this.propertyValueList = propertyValueList;
	}

	@Override
	public List<PropertyDef> getPropertyDefList() {
		if (StringUtils.isNotBlank(this.getTemplateId())) {
			TemplateConf templateConf = SpringContextHolder.getOneBean(TemplateConfService.class).queryObjById(this.getTemplateId());
			return templateConf.getMouldPropertyDefList();
			
		}else if(StringUtils.isNotBlank(this.getPurOrderId())){
			PurOrder purOrder = SpringContextHolder.getOneBean(PurOrderService.class).queryObjById(this.getPurOrderId());
			if (purOrder!=null && StringUtils.isNotBlank(purOrder.getTemplateId())) {
				TemplateConf templateConf = SpringContextHolder.getOneBean(TemplateConfService.class).queryObjById(purOrder.getTemplateId());
				return templateConf.getMouldPropertyDefList();
			}
		}
		return PropertyDefUtils.getProperyDefByClass(this.getClass());
	}
	/*-------------请勿覆盖---------------------*/
	
    @ApiModelProperty(hidden=true, value="主键")
    private String id;

    @ApiModelProperty(hidden=true, value="询价单头id")
    private String purOrderId;

    @ApiModelProperty("供应商编码")
    private String supCompanySrmCode;

    @ApiModelProperty("供应商名称")
    private String supCompanyName;

    @ApiModelProperty(position=1,value="模具编码")
    private String mouldCode;

    @ApiModelProperty(position=2,value="模具名称")
    private String mouldName;

    @ApiModelProperty(position=3,value="模具规格")
    private String mouldSpecifications;

    @ApiModelProperty(position=4, value="模具材料")
    private String moldMaterial;

    @ApiModelProperty(position=5,value="模具寿命")
    private Integer moldLife;

    @ApiModelProperty(position=6,value="出模数")
    private Integer outOfModulus;

    @ApiModelProperty(hidden=true, value="产品编码")
    private String productCode;

    @ApiModelProperty(hidden=true, value="产品名称")
    private String productName;

    @ApiModelProperty(position=7,value="不含税单价")
    private BigDecimal untaxedUnitPrice;

    @ApiModelProperty(position=8,value="含税单价")
    private BigDecimal taxUnitPrice;

    @ApiModelProperty(hidden=true, value="模具价格分析")
    private String mouldPriceAnalysis;

    @ApiModelProperty(position=10,value="物料明细",dataType="button")
    private String materiel;

    @ApiModelProperty(position=12, value="备注")
    private String remarks;

    @ApiModelProperty(hidden=true, value="创建时间")
    private Date createTime;

    @ApiModelProperty(hidden=true, value="更新时间")
    private Date updateTime;

    @ApiModelProperty(hidden=true, value="记录是否可用(0=不可用，1=可用)")
    private Integer isEnable;

    @ApiModelProperty(hidden=true, value="排序号")
    private Integer sortNo;

    @ApiModelProperty(hidden=true, value="待询价物料ID")
    private String waitMaterialId;

    @ApiModelProperty(hidden=true, value="模板id")
    private String templateId;

    @ApiModelProperty(hidden=true, value="供应商询价单头id")
    private String supOrderId;

    @ApiModelProperty(hidden=true, value="供应商id")
    private String supCompanyId;

    @ApiModelProperty("供应商SAP编码")
    private String supCompanySapCode;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getPurOrderId() {
        return purOrderId;
    }

    public void setPurOrderId(String purOrderId) {
        this.purOrderId = purOrderId == null ? null : purOrderId.trim();
    }

    public String getSupCompanySrmCode() {
        return supCompanySrmCode;
    }

    public void setSupCompanySrmCode(String supCompanySrmCode) {
        this.supCompanySrmCode = supCompanySrmCode == null ? null : supCompanySrmCode.trim();
    }

    public String getSupCompanyName() {
        return supCompanyName;
    }

    public void setSupCompanyName(String supCompanyName) {
        this.supCompanyName = supCompanyName == null ? null : supCompanyName.trim();
    }

    public String getMouldCode() {
        return mouldCode;
    }

    public void setMouldCode(String mouldCode) {
        this.mouldCode = mouldCode == null ? null : mouldCode.trim();
    }

    public String getMouldName() {
        return mouldName;
    }

    public void setMouldName(String mouldName) {
        this.mouldName = mouldName == null ? null : mouldName.trim();
    }

    public String getMouldSpecifications() {
        return mouldSpecifications;
    }

    public void setMouldSpecifications(String mouldSpecifications) {
        this.mouldSpecifications = mouldSpecifications == null ? null : mouldSpecifications.trim();
    }

    public String getMoldMaterial() {
        return moldMaterial;
    }

    public void setMoldMaterial(String moldMaterial) {
        this.moldMaterial = moldMaterial == null ? null : moldMaterial.trim();
    }

    public Integer getMoldLife() {
        return moldLife;
    }

    public void setMoldLife(Integer moldLife) {
        this.moldLife = moldLife;
    }

    public Integer getOutOfModulus() {
        return outOfModulus;
    }

    public void setOutOfModulus(Integer outOfModulus) {
        this.outOfModulus = outOfModulus;
    }

    public String getProductCode() {
        return productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode == null ? null : productCode.trim();
    }

    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName == null ? null : productName.trim();
    }

    @Override
    public BigDecimal getUntaxedUnitPrice() {
        return untaxedUnitPrice;
    }

    public void setUntaxedUnitPrice(BigDecimal untaxedUnitPrice) {
        this.untaxedUnitPrice = untaxedUnitPrice;
    }

    public BigDecimal getTaxUnitPrice() {
        return taxUnitPrice;
    }

    public void setTaxUnitPrice(BigDecimal taxUnitPrice) {
        this.taxUnitPrice = taxUnitPrice;
    }

    public String getMouldPriceAnalysis() {
        return mouldPriceAnalysis;
    }

    public void setMouldPriceAnalysis(String mouldPriceAnalysis) {
        this.mouldPriceAnalysis = mouldPriceAnalysis == null ? null : mouldPriceAnalysis.trim();
    }

    public String getMateriel() {
        return materiel;
    }

    public void setMateriel(String materiel) {
        this.materiel = materiel == null ? null : materiel.trim();
    }

    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks == null ? null : remarks.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Integer getIsEnable() {
        return isEnable;
    }

    public void setIsEnable(Integer isEnable) {
        this.isEnable = isEnable;
    }

    public Integer getSortNo() {
        return sortNo;
    }

    public void setSortNo(Integer sortNo) {
        this.sortNo = sortNo;
    }

    public String getWaitMaterialId() {
        return waitMaterialId;
    }

    public void setWaitMaterialId(String waitMaterialId) {
        this.waitMaterialId = waitMaterialId == null ? null : waitMaterialId.trim();
    }

    public String getTemplateId() {
        return templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId == null ? null : templateId.trim();
    }

    public String getSupOrderId() {
        return supOrderId;
    }

    public void setSupOrderId(String supOrderId) {
        this.supOrderId = supOrderId == null ? null : supOrderId.trim();
    }

    public String getSupCompanyId() {
        return supCompanyId;
    }

    public void setSupCompanyId(String supCompanyId) {
        this.supCompanyId = supCompanyId == null ? null : supCompanyId.trim();
    }

    public String getSupCompanySapCode() {
        return supCompanySapCode;
    }

    public void setSupCompanySapCode(String supCompanySapCode) {
        this.supCompanySapCode = supCompanySapCode == null ? null : supCompanySapCode.trim();
    }

}